/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.block;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.common.menus.variant.BlockVariantSelectMenu;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IVariantBlock {
    public static final BooleanProperty VARIANT = BooleanProperty.m_61465_((String)"variant");

    default public int getModelIndex(BlockState state) {
        int index = 0;
        boolean wide = this instanceof IWideBlock;
        boolean tall = this instanceof ITallBlock;
        boolean deep = this instanceof IDeepBlock;
        if (wide && !((Boolean)state.m_61143_((Property)IWideBlock.ISLEFT)).booleanValue()) {
            ++index;
        }
        if (deep && !((Boolean)state.m_61143_((Property)IDeepBlock.IS_FRONT)).booleanValue()) {
            index += wide ? 2 : 1;
        }
        if (tall && !((Boolean)state.m_61143_((Property)ITallBlock.ISBOTTOM)).booleanValue()) {
            index += wide && deep ? 4 : (wide || deep ? 2 : 1);
        }
        return index;
    }

    default public ResourceLocation getBlockID() {
        IVariantBlock iVariantBlock = this;
        if (iVariantBlock instanceof Block) {
            Block block = (Block)iVariantBlock;
            return ForgeRegistries.BLOCKS.getKey((Object)block);
        }
        throw new IllegalStateException("IVariantBlock must be applied to a Block class!");
    }

    default public ResourceLocation getItemID() {
        IVariantBlock iVariantBlock = this;
        if (iVariantBlock instanceof ItemLike) {
            ItemLike item = (ItemLike)iVariantBlock;
            return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        }
        return this.getBlockID();
    }

    default public boolean isRotatable() {
        return this instanceof IRotatableBlock;
    }

    default public List<ResourceLocation> getValidVariants() {
        return ModelVariantDataManager.getPotentialVariants(this.getBlockID());
    }

    default public int requiredModels() {
        return this.modelsFromBlockState();
    }

    default public int modelsFromBlockState() {
        int count = 1;
        if (this instanceof IWideBlock) {
            count *= 2;
        }
        if (this instanceof ITallBlock) {
            count *= 2;
        }
        if (this instanceof IDeepBlock) {
            count *= 2;
        }
        return count;
    }

    @Nullable
    default public ResourceLocation getCustomDefaultModel(int index) {
        return null;
    }

    public static boolean tryUseWand(Player player, BlockPos pos) {
        Level level = player.m_9236_();
        BlockState state = level.m_8055_(pos);
        IVariantBlock block = VariantProvider.getVariantBlock(state.m_60734_());
        if (block != null && player instanceof ServerPlayer) {
            IOwnableBlock ownable;
            ServerPlayer sp = (ServerPlayer)player;
            Block block2 = state.m_60734_();
            if (block2 instanceof IOwnableBlock && !(ownable = (IOwnableBlock)block2).canBreak(player, (LevelAccessor)level, pos, state)) {
                return false;
            }
            if (level.f_46443_) {
                return true;
            }
            IVariantDataStorage data = IVariantDataStorage.get((BlockGetter)level, pos);
            if (data != null && data.isVariantLocked() && !player.m_7500_()) {
                player.m_5661_((Component)LCText.TOOLTIP_MODEL_VARIANT_LOCKED.getWithStyle(ChatFormatting.RED), true);
                return true;
            }
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)BlockVariantSelectMenu.providerFor(pos), (BlockPos)pos);
            return true;
        }
        return false;
    }

    public static void copyDataToItem(@Nullable IVariantDataStorage data, ItemStack item) {
        if (data == null) {
            return;
        }
        IVariantBlock.copyDataToItem(data.getCurrentVariant(), data.isVariantLocked(), item);
    }

    public static void copyDataToItem(@Nullable ResourceLocation variant, boolean variantLocked, ItemStack item) {
        IVariantItem.setItemVariant(item, variant);
        IVariantItem.setLocked(item, variantLocked);
    }

    public static void copyDataFromItem(@Nullable IVariantDataStorage data, ItemStack item) {
        if (data == null) {
            return;
        }
        data.setVariant(IVariantItem.getItemVariant(item), IVariantItem.isLocked(item));
    }
}

