/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.block.builtin;

import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.network.message.cap.SPacketSyncVariantChunkCap;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class VariantChunkDataStorageAttachment
implements ICapabilitySerializable<ListTag>,
IClientTracker {
    public static final Capability<VariantChunkDataStorageAttachment> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<VariantChunkDataStorageAttachment>(){});
    private final LazyOptional<VariantChunkDataStorageAttachment> optional = LazyOptional.of(() -> this);
    private final LevelChunk parent;
    private final Map<BlockPos, DataHolder> data = new HashMap<BlockPos, DataHolder>();

    public VariantChunkDataStorageAttachment(LevelChunk parent) {
        this.parent = parent;
    }

    @Override
    public boolean isClient() {
        return this.parent.m_62953_().f_46443_;
    }

    public IVariantDataStorage getData(BlockPos pos) {
        return new DataWrapper(this, pos);
    }

    private DataHolder getOrCreateData(BlockPos pos) {
        if (!this.data.containsKey(pos)) {
            return new DataHolder();
        }
        return this.data.get(pos);
    }

    private void setChanged() {
        if (this.isServer()) {
            new SPacketSyncVariantChunkCap(this.parent.m_7697_(), this.copyData()).sendToTarget(PacketDistributor.TRACKING_CHUNK.with(() -> this.parent));
        }
    }

    public void loadData(Map<BlockPos, DataHolder> data) {
        if (this.isServer()) {
            return;
        }
        this.data.clear();
        data.forEach((pos, entry) -> this.data.put((BlockPos)pos, entry.copy()));
    }

    private Map<BlockPos, DataHolder> copyData() {
        HashMap<BlockPos, DataHolder> result = new HashMap<BlockPos, DataHolder>();
        this.data.forEach((pos, entry) -> result.put((BlockPos)pos, entry.copy()));
        return result;
    }

    public void syncWith(ServerPlayer player) {
        new SPacketSyncVariantChunkCap(this.parent.m_7697_(), this.copyData()).sendTo(player);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        return CAP.orEmpty(capability, this.optional);
    }

    public ListTag serializeNBT() {
        ListTag tag = new ListTag();
        this.data.forEach((pos, data) -> {
            CompoundTag entry = data.write();
            entry.m_128365_("pos", (Tag)TagUtil.saveBlockPos(pos));
            tag.add((Object)entry);
        });
        return tag;
    }

    public void deserializeNBT(ListTag tag) {
        this.data.clear();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag entry = tag.m_128728_(i);
            DataHolder data = DataHolder.read(tag.m_128728_(i));
            BlockPos pos = TagUtil.loadBlockPos(entry.m_128469_("pos"));
            this.data.put(pos, data);
        }
    }

    private record DataWrapper(VariantChunkDataStorageAttachment parent, BlockPos pos) implements IVariantDataStorage
    {
        @Override
        @Nullable
        public ResourceLocation getCurrentVariant() {
            DataHolder data = this.parent.data.get(this.pos);
            return data != null ? data.variantID : null;
        }

        @Override
        public boolean isVariantLocked() {
            DataHolder data = this.parent.data.get(this.pos);
            return data != null && data.locked;
        }

        @Override
        public void setVariant(@Nullable ResourceLocation variant, boolean locked) {
            DataHolder data = this.parent.getOrCreateData(this.pos);
            data.variantID = variant;
            data.locked = locked;
            if (data.shouldSave()) {
                this.parent.data.put(this.pos, data);
            } else {
                this.parent.data.remove(this.pos);
            }
            this.parent.setChanged();
        }
    }

    public static class DataHolder {
        @Nullable
        public ResourceLocation variantID;
        public boolean locked = false;

        private boolean shouldSave() {
            return this.variantID != null || this.locked;
        }

        DataHolder copy() {
            DataHolder copy = new DataHolder();
            copy.variantID = this.variantID;
            copy.locked = this.locked;
            return copy;
        }

        private CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            if (this.variantID != null) {
                tag.m_128359_("variant", this.variantID.toString());
            }
            if (this.locked) {
                tag.m_128379_("locked", true);
            }
            return tag;
        }

        private static DataHolder read(CompoundTag tag) {
            DataHolder result = new DataHolder();
            if (tag.m_128441_("variant")) {
                result.variantID = VersionUtil.parseResource(tag.m_128461_("variant"));
            }
            result.locked = tag.m_128471_("locked");
            return result;
        }

        public void encode(FriendlyByteBuf buffer) {
            boolean hasVariant = this.variantID != null;
            buffer.writeBoolean(hasVariant);
            if (hasVariant) {
                buffer.m_130085_(this.variantID);
            }
            buffer.writeBoolean(this.locked);
        }

        public static DataHolder decode(FriendlyByteBuf buffer) {
            DataHolder result = new DataHolder();
            if (buffer.readBoolean()) {
                result.variantID = buffer.m_130281_();
            }
            result.locked = buffer.readBoolean();
            return result;
        }
    }
}

