/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.data;

import io.github.lightman314.lightmanscurrency.network.message.player.CPacketRequestID;
import io.github.lightman314.lightmanscurrency.network.message.player.CPacketRequestName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientPlayerNameCache {
    private static final Map<UUID, String> cache = new HashMap<UUID, String>();
    private static final List<UUID> sentNameRequests = new ArrayList<UUID>();
    private static final List<String> sentIDRequests = new ArrayList<String>();

    @Nullable
    public static String lookupName(@Nonnull UUID playerID) {
        return ClientPlayerNameCache.lookupName(playerID, true);
    }

    @Nullable
    public static String lookupName(@Nonnull UUID playerID, boolean sendDataRequest) {
        if (cache.containsKey(playerID)) {
            return cache.get(playerID);
        }
        if (sendDataRequest && !sentNameRequests.contains(playerID)) {
            sentNameRequests.add(playerID);
            new CPacketRequestName(playerID).send();
        }
        return null;
    }

    @Nullable
    public static UUID lookupID(@Nonnull String playerName) {
        return ClientPlayerNameCache.lookupID(playerName, true);
    }

    @Nullable
    public static UUID lookupID(@Nonnull String playerName, boolean sendDataRequest) {
        for (Map.Entry<UUID, String> entry : cache.entrySet()) {
            String name = entry.getValue();
            if (name == null || !name.equalsIgnoreCase(playerName)) continue;
            return entry.getKey();
        }
        if (sendDataRequest && !sentIDRequests.contains(playerName)) {
            sentIDRequests.add(playerName);
            new CPacketRequestID(playerName).send();
        }
        return null;
    }

    public static void addCacheEntry(@Nonnull UUID playerID, @Nonnull String playerName) {
        cache.put(playerID, playerName);
        sentNameRequests.remove(playerID);
        for (int i = 0; i < sentIDRequests.size(); ++i) {
            if (!sentIDRequests.get(i).equalsIgnoreCase(playerName)) continue;
            sentIDRequests.remove(i--);
        }
    }
}

