/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.EasyClientTabbedMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ExchangeTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.InteractionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.LogTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.NotificationTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.SelectionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.TransferTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary.SalaryTab;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ATMScreen
extends EasyClientTabbedMenuScreen<ATMMenu, ATMScreen, ATMTab> {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/atm.png");
    public static final ResourceLocation BUTTON_TEXTURE = VersionUtil.lcResource("textures/gui/container/atm_buttons.png");

    public ATMScreen(ATMMenu container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.resize(176, 243);
        this.initializeTabs();
        ((ATMMenu)this.f_97732_).addMessageListener(message -> ((ATMTab)this.currentTab()).HandleMessage((LazyPacketData)message));
    }

    @Override
    protected IWidgetPositioner getTabButtonPositioner() {
        return LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(WidgetRotation.LEFT), ScreenPosition.of(-25, 0), 25);
    }

    @Override
    protected void init(ScreenArea screenArea) {
    }

    @Override
    protected void registerTabs() {
        this.addTab(new ExchangeTab(this));
        this.addTab(new SelectionTab(this));
        this.addTab(new InteractionTab(this));
        this.addTab(new NotificationTab(this));
        this.addTab(new LogTab(this));
        this.addTab(new TransferTab(this));
        this.addTab(new SalaryTab(this));
    }

    @Override
    protected void renderBackground(EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        for (CoinSlot slot : ((ATMMenu)this.f_97732_).getCoinSlots()) {
            gui.renderSlot((IEasyScreen)this, slot);
        }
        if (((ATMTab)this.currentTab()).renderInventoryLabel()) {
            gui.drawString(this.f_169604_, 8, this.getYSize() - 94, 0x404040);
        }
    }

    public void setCoinSlotsActive(boolean active) {
        EasySlot.SetActive(((ATMMenu)this.f_97732_).getCoinSlots(), active);
    }
}

