/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.IntParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextBoxWrapper;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.FreeSample;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FreeSampleTab
extends TradeRuleSubTab<FreeSample> {
    TextBoxWrapper<Integer> limitInput;
    EasyButton buttonClearMemory;
    TimeInputWidget timeInput;

    public FreeSampleTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, FreeSample.TYPE);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        FreeSample rule = (FreeSample)this.getRule();
        this.limitInput = this.addChild(TextInputUtil.intBuilder().position(screenArea.pos.offset(10, 19)).width(30).parser(IntParser.ONE_TO_ONE_HUNDRED).handler(this::onLimitChanged).maxLength(3).startingValue(rule == null ? 1 : rule.getLimit()).wrap().build());
        this.buttonClearMemory = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 55))).width(screenArea.width - 20)).text(LCText.BUTTON_FREE_SAMPLE_RESET).pressAction(this::PressClearMemoryButton)).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_FREE_SAMPLE_RESET))).build());
        this.timeInput = this.addChild(((TimeInputWidget.Builder)TimeInputWidget.builder().position(screenArea.pos.offset(63, 92))).unitRange(TimeUtil.TimeUnit.MINUTE, TimeUtil.TimeUnit.DAY).handler(this::onTimeSet).startTime(rule == null ? 0L : rule.getTimeLimit()).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        FreeSample rule = (FreeSample)this.getRule();
        if (rule != null) {
            gui.drawString((Component)LCText.GUI_FREE_SAMPLE_INFO.get(rule.getLimit()), 10, 9, 0x404040);
            TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_FREE_SAMPLE_PLAYER_COUNT.get(rule.getSampleCount()), 10, this.screen.getXSize() - 20, 44, 0x404040);
            MutableComponent text = ((FreeSample)this.getRule()).getTimeLimit() > 0L ? LCText.GUI_PLAYER_TRADE_LIMIT_DURATION.get(new TimeUtil.TimeData(rule.getTimeLimit()).getShortString()) : LCText.GUI_PLAYER_TRADE_LIMIT_NO_DURATION.get(new Object[0]);
            TextRenderUtil.drawCenteredText(gui, (Component)text, this.screen.getXSize() / 2, 80, 0x404040);
        }
    }

    void onLimitChanged(int newLimit) {
        FreeSample rule = (FreeSample)this.getRule();
        if (rule != null) {
            rule.setLimit(newLimit);
        }
        this.sendUpdateMessage(this.builder().setInt("Limit", newLimit));
    }

    void PressClearMemoryButton(EasyButton button) {
        FreeSample rule = (FreeSample)this.getRule();
        if (rule != null) {
            rule.resetMemory();
        }
        this.sendUpdateMessage(this.builder().setFlag("ClearMemory"));
    }

    public void onTimeSet(TimeUtil.TimeData newTime) {
        long timeLimit = MathUtil.clamp(newTime.miliseconds, 0L, Long.MAX_VALUE);
        FreeSample rule = (FreeSample)this.getRule();
        if (rule != null) {
            rule.setTimeLimit(timeLimit);
        }
        this.sendUpdateMessage(this.builder().setLong("TimeLimit", timeLimit));
    }
}

