/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.model;

import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelProperty;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VariantItemModel
extends BakedModelWrapper<BakedModel> {
    private static final ModelProperty<ResourceLocation> VARIANT = new ModelProperty();
    private static final ModelProperty<BlockState> STATE = new ModelProperty();
    private final Map<ResourceLocation, BakedModel> itemModelCache = new HashMap<ResourceLocation, BakedModel>();
    private final IVariantItem item;
    private final BakedModel defaultModel;
    private final ItemOverrides overrides;

    public VariantItemModel(IVariantItem item, BakedModel defaultModel) {
        super(defaultModel);
        this.item = item;
        this.defaultModel = defaultModel;
        this.overrides = new Overrides();
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return this.getModel(itemStack).getRenderTypes(itemStack, fabulous);
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return List.of(this.getModel(itemStack));
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    private BakedModel getModel(ItemStack item) {
        ResourceLocation variantID = IVariantItem.getItemVariant(item);
        if (variantID == null) {
            return this.defaultModel;
        }
        if (this.itemModelCache.containsKey(variantID)) {
            return this.itemModelCache.get(variantID);
        }
        ModelVariant variant = ModelVariantDataManager.getVariant(variantID);
        if (variant == null || !variant.isValidTarget(this.item)) {
            this.itemModelCache.put(variantID, this.defaultModel);
            return this.defaultModel;
        }
        VariantModelLocation modelID = VariantModelLocation.item(variantID, this.item.getItemID());
        BakedModel model = modelID == null ? this.defaultModel : ModelVariantDataManager.getModel(modelID);
        this.itemModelCache.put(variantID, model);
        return model;
    }

    private class Overrides
    extends ItemOverrides {
        private Overrides() {
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            model = VariantItemModel.this.getModel(stack);
            return model.m_7343_().m_173464_(model, stack, level, entity, seed);
        }
    }
}

