/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.TargetSelectorHelper;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.IIndependentProperty;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperty;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantPropertyWithDefault;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class UnbakedVariant {
    private boolean completelyInvalid = false;
    private boolean invalid = false;
    private final boolean itemVariant;
    private final boolean dummy;
    private final boolean optional;
    @Nullable
    private final ResourceLocation parent;
    @Nullable
    private UnbakedVariant parentVariant = null;
    private final List<String> targetSelectors;
    private final List<ResourceLocation> targets;
    @Nullable
    private final Component name;
    @Nullable
    private final ResourceLocation item;
    private final List<ResourceLocation> models;
    private final Map<String, ResourceLocation> textureOverrides;
    private final Map<ResourceLocation, Object> properties;

    public boolean shouldRemove() {
        return this.completelyInvalid || this.parentVariant != null && this.parentVariant.shouldRemove();
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isInvalid() {
        return this.shouldRemove() || this.invalid || this.dummy;
    }

    public boolean isItemVariant() {
        if (!this.itemVariant && this.parentVariant != null) {
            return this.parentVariant.isItemVariant();
        }
        return this.itemVariant;
    }

    public List<String> getTargetSelectors() {
        ArrayList<String> result = new ArrayList<String>(this.targetSelectors);
        if (this.parentVariant != null) {
            result.addAll(this.parentVariant.getTargetSelectors());
        }
        return result;
    }

    public List<ResourceLocation> getTargets() {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>(this.targets);
        if (this.parentVariant != null) {
            result.addAll(this.parentVariant.getTargets());
        }
        return result;
    }

    public Component getName() {
        if (this.name == null && this.parentVariant != null) {
            return this.parentVariant.getName();
        }
        return this.name;
    }

    @Nullable
    public ResourceLocation getItemModel() {
        if (this.item == null && this.parent != null) {
            return this.parentVariant == null ? null : this.parentVariant.getItemModel();
        }
        return this.item;
    }

    @Nullable
    public ItemStack getItemIcon() {
        return null;
    }

    public boolean hasModels() {
        return !this.getModels().isEmpty();
    }

    public List<ResourceLocation> getModels() {
        if (this.models.isEmpty() && this.parent != null) {
            return this.parentVariant == null ? ImmutableList.of() : this.parentVariant.getModels();
        }
        return this.models;
    }

    public boolean hasTextureOverrides() {
        return !this.getTextureOverrides().isEmpty();
    }

    public Map<String, ResourceLocation> getTextureOverrides() {
        if (this.parentVariant != null) {
            HashMap<String, ResourceLocation> combinedMap = new HashMap<String, ResourceLocation>(this.parentVariant.getTextureOverrides());
            combinedMap.putAll(this.textureOverrides);
            return ImmutableMap.copyOf(combinedMap);
        }
        return this.textureOverrides;
    }

    private UnbakedVariant(@Nullable ResourceLocation parent, List<ResourceLocation> targets, List<String> selectorTargets, @Nullable Component name, @Nullable ResourceLocation item, List<ResourceLocation> models, Map<String, ResourceLocation> textureOverrides, Map<ResourceLocation, Object> properties, boolean itemVariant, boolean dummy, boolean optional) {
        this.parent = parent;
        this.targets = ImmutableList.copyOf(targets);
        this.targetSelectors = ImmutableList.copyOf(selectorTargets);
        this.name = name;
        this.item = item;
        this.models = ImmutableList.copyOf(models);
        this.textureOverrides = ImmutableMap.copyOf(textureOverrides);
        this.properties = ImmutableMap.copyOf(properties);
        this.itemVariant = itemVariant;
        this.dummy = dummy;
        this.optional = optional;
    }

    public boolean has(VariantProperty<?> property) {
        if (this.parentVariant != null && this.parentVariant.has(property)) {
            return true;
        }
        return this.properties.containsKey(property.getID());
    }

    @Nullable
    public <T> T get(VariantProperty<T> property) {
        try {
            if (!this.properties.containsKey(property.getID()) && this.parentVariant != null) {
                return this.parentVariant.get(property);
            }
            return (T)this.properties.get(property.getID());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public <T> T getOrDefault(VariantProperty<T> property, T defaultValue) {
        T result = this.get(property);
        return result == null ? defaultValue : result;
    }

    public <T> T getOrDefault(VariantPropertyWithDefault<T> property) {
        return this.getOrDefault(property, property.getMissingDefault());
    }

    public JsonObject write() {
        JsonArray array;
        JsonObject json = new JsonObject();
        if (this.parent != null) {
            json.addProperty("parent", this.parent.toString());
        }
        if (this.targets.size() == 1) {
            json.addProperty("target", this.targets.get(0).toString());
        } else if (!this.targets.isEmpty()) {
            array = new JsonArray();
            for (ResourceLocation resourceLocation : this.targets) {
                array.add(resourceLocation.toString());
            }
            json.add("target", (JsonElement)array);
        }
        if (this.targetSelectors.size() == 1) {
            json.addProperty("targetSelector", this.targetSelectors.get(0));
        } else if (!this.targetSelectors.isEmpty()) {
            array = new JsonArray();
            for (String string : this.targetSelectors) {
                array.add(string);
            }
            json.add("targetSelector", (JsonElement)array);
        }
        if (this.name != null) {
            json.add("name", Component.Serializer.m_130716_((Component)this.name));
        }
        if (this.item != null) {
            json.addProperty("item", this.item.toString());
        }
        if (!this.models.isEmpty()) {
            JsonArray models = new JsonArray();
            for (ResourceLocation resourceLocation : this.models) {
                models.add(resourceLocation.toString());
            }
            json.add("models", (JsonElement)models);
        }
        if (!this.textureOverrides.isEmpty()) {
            JsonObject textures = new JsonObject();
            this.textureOverrides.forEach((key, texture) -> textures.addProperty(key, texture.toString()));
            json.add("textures", (JsonElement)textures);
        }
        this.properties.forEach((propID, value) -> {
            try {
                VariantProperty<?> property = VariantProperty.getProperty(propID);
                JsonElement element = property.write(value);
                ResourceLocation id = property.getID();
                String field = id.m_135827_().equals("lightmanscurrency") ? id.m_135815_() : id.toString();
                json.add(field, element);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error writing Variant Property", e);
            }
        });
        if (this.itemVariant) {
            json.addProperty("itemVariant", Boolean.valueOf(true));
        }
        if (this.dummy) {
            json.addProperty("dummy", Boolean.valueOf(true));
        }
        if (this.optional) {
            json.addProperty("optional", Boolean.valueOf(true));
        }
        return json;
    }

    public static UnbakedVariant parse(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        ResourceLocation parent = null;
        if (json.has("parent")) {
            parent = VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"parent"));
        }
        ArrayList<ResourceLocation> targets = new ArrayList<ResourceLocation>();
        if (json.has("target")) {
            JsonElement targetElement = json.get("target");
            if (targetElement.isJsonPrimitive()) {
                UnbakedVariant.addTarget(targets, VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"target")));
            } else {
                JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"target");
                for (int i = 0; i < array.size(); ++i) {
                    UnbakedVariant.addTarget(targets, VersionUtil.parseResource(GsonHelper.m_13805_((JsonElement)array.get(i), (String)("target[" + i + "]"))));
                }
            }
        }
        ArrayList<String> targetSelectors = new ArrayList<String>();
        if (json.has("targetSelector")) {
            JsonElement targetElement = json.get("targetSelector");
            if (targetElement.isJsonPrimitive()) {
                targetSelectors.add(GsonHelper.m_13906_((JsonObject)json, (String)"targetSelector"));
            } else {
                JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"targetSelector");
                for (int i = 0; i < array.size(); ++i) {
                    targetSelectors.add(GsonHelper.m_13805_((JsonElement)array.get(i), (String)("targetSelector[" + i + "]")));
                }
            }
        }
        MutableComponent name = null;
        if (json.has("name")) {
            name = Component.Serializer.m_130691_((JsonElement)json.get("name"));
        }
        ResourceLocation item = null;
        if (json.has("item")) {
            item = VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
        } else if (json.has("icon")) {
            item = VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"icon"));
        }
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
        if (json.has("models")) {
            JsonArray modelList = GsonHelper.m_13933_((JsonObject)json, (String)"models");
            for (int i = 0; i < modelList.size(); ++i) {
                models.add(VersionUtil.parseResource(GsonHelper.m_13805_((JsonElement)modelList.get(i), (String)("models[" + i + "]"))));
            }
        }
        HashMap<String, ResourceLocation> textureOverrides = new HashMap<String, ResourceLocation>();
        if (json.has("textures")) {
            JsonObject textures = GsonHelper.m_13930_((JsonObject)json, (String)"textures");
            for (Map.Entry entry : textures.entrySet()) {
                ResourceLocation t = VersionUtil.parseResource(GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey())));
                textureOverrides.put((String)entry.getKey(), t);
            }
        }
        HashMap<ResourceLocation, Object> properties = new HashMap<ResourceLocation, Object>();
        VariantProperty.forEach((id, property) -> {
            if (json.has(id.toString())) {
                properties.put((ResourceLocation)id, property.parse(json.get(id.toString())));
            } else if (id.m_135827_().equals("lightmanscurrency") && json.has(id.m_135815_())) {
                properties.put((ResourceLocation)id, property.parse(json.get(id.m_135815_())));
            }
        });
        if (targets.isEmpty() && name == null && item == null && models.isEmpty() && textureOverrides.isEmpty() && properties.isEmpty()) {
            if (parent == null) {
                throw new JsonSyntaxException("Model Variant must have something defined!");
            }
            throw new JsonSyntaxException("Model Variant must have something other than the parent defined!");
        }
        boolean itemVariant = GsonHelper.m_13855_((JsonObject)json, (String)"itemVariant", (boolean)false);
        boolean dummy = GsonHelper.m_13855_((JsonObject)json, (String)"dummy", (boolean)false);
        boolean optional = GsonHelper.m_13855_((JsonObject)json, (String)"optional", (boolean)false);
        return new UnbakedVariant(parent, targets, targetSelectors, (Component)name, item, models, textureOverrides, properties, itemVariant, dummy, optional);
    }

    public void validate(@Nullable Map<ResourceLocation, UnbakedVariant> otherVariants, ResourceLocation id) {
        if (this.parent != null) {
            if (otherVariants == null) {
                return;
            }
            LoopData loop = new LoopData(id, this);
            if (otherVariants.containsKey(this.parent)) {
                this.parentVariant = otherVariants.get(this.parent);
                if (this.parentVariant.checkForLoop(otherVariants, this.parent, loop)) {
                    LightmansCurrency.LogWarning("Detected infinite loop in " + id);
                    this.completelyInvalid = true;
                    return;
                }
                this.invalid = UnbakedVariant.invalidWhenCombined(loop, id);
            } else {
                this.completelyInvalid = true;
            }
        } else if (otherVariants != null) {
            this.invalid = UnbakedVariant.invalidWhenCombined(new LoopData(id, this), id);
        }
    }

    private static boolean invalidWhenCombined(LoopData loop) {
        return UnbakedVariant.invalidWhenCombined(loop, null);
    }

    private static boolean invalidWhenCombined(LoopData loop, @Nullable ResourceLocation id) {
        boolean bl;
        boolean hasTarget = false;
        List<Object> targets = new ArrayList();
        for (UnbakedVariant unbakedVariant : loop.variants) {
            if (unbakedVariant.targets.isEmpty()) continue;
            hasTarget = true;
            targets = unbakedVariant.targets;
            break;
        }
        if (!hasTarget) {
            if (id != null && !loop.optional()) {
                LightmansCurrency.LogDebug(id + " has no valid targets!");
            }
            return true;
        }
        boolean hasTextures = false;
        for (UnbakedVariant unbakedVariant : loop.variants) {
            if (unbakedVariant.textureOverrides.isEmpty()) continue;
            hasTextures = true;
            break;
        }
        boolean bl2 = false;
        for (UnbakedVariant v4 : loop.variants) {
            if (v4.item == null) continue;
            bl = true;
            break;
        }
        boolean bl3 = loop.variants.stream().anyMatch(v -> v.itemVariant);
        boolean hasModels = false;
        for (UnbakedVariant unbakedVariant : loop.variants) {
            if (unbakedVariant.models.isEmpty()) continue;
            hasModels = true;
            if (!bl3) {
                for (ResourceLocation resourceLocation : targets) {
                    if (!ForgeRegistries.BLOCKS.containsKey(resourceLocation)) {
                        if (id != null && !loop.optional()) {
                            LightmansCurrency.LogDebug(id + " targets a block that doesn't exist (" + resourceLocation + ")");
                        }
                        return true;
                    }
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
                    IVariantBlock vb = VariantProvider.getVariantBlock(block);
                    if (vb != null) {
                        if (vb.requiredModels() == unbakedVariant.models.size()) continue;
                        if (id != null && !loop.optional()) {
                            LightmansCurrency.LogDebug(id + " does not have the same model count as " + resourceLocation);
                        }
                        return true;
                    }
                    if (id != null) {
                        LightmansCurrency.LogDebug(id + " targets an invalid variant block (" + resourceLocation + ")");
                    }
                    return true;
                }
                continue;
            }
            for (ResourceLocation resourceLocation : targets) {
                if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
                    if (id != null && !loop.optional()) {
                        LightmansCurrency.LogDebug(id + " targets an item that doesn't exist (" + resourceLocation + ")");
                    }
                    return true;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                IVariantItem vi = VariantProvider.getVariantItem(item);
                if (vi != null) {
                    if (vi.requiredModels() == unbakedVariant.models.size()) continue;
                    if (id != null && !loop.optional()) {
                        LightmansCurrency.LogDebug(id + " does not have the same model count as " + resourceLocation);
                    }
                    return true;
                }
                if (id != null && !loop.optional()) {
                    LightmansCurrency.LogDebug(id + " targets an invalid variant item (" + resourceLocation + ")");
                }
                return true;
            }
        }
        if (!hasModels && bl3) {
            for (ResourceLocation resourceLocation : targets) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                IVariantItem iVariantItem = VariantProvider.getVariantItem(item);
                if (iVariantItem != null) {
                    if (iVariantItem.requiredModels() <= 0) continue;
                    if (id != null && !loop.optional()) {
                        LightmansCurrency.LogDebug(id + " does not have the same model count as " + resourceLocation);
                    }
                    return true;
                }
                if (id != null && !loop.optional()) {
                    LightmansCurrency.LogDebug(id + " targets an invalid variant item (" + resourceLocation + ")");
                }
                return true;
            }
            hasModels = bl;
        }
        boolean hasIndependentProperty = false;
        block7: for (UnbakedVariant v6 : loop.variants) {
            if (hasIndependentProperty) break;
            for (Object value : v6.properties.values()) {
                if (!(value instanceof IIndependentProperty)) continue;
                hasIndependentProperty = true;
                continue block7;
            }
        }
        if (hasModels != bl && !bl3) {
            if (id != null && !loop.optional()) {
                if (hasModels) {
                    LightmansCurrency.LogDebug(id + " has custom block models defined, but no custom item model");
                } else {
                    LightmansCurrency.LogDebug(id + " has a custom item model defined, but no custom block models");
                }
            }
            return true;
        }
        if (!(hasTextures || hasModels || hasIndependentProperty)) {
            if (id != null && !loop.optional()) {
                LightmansCurrency.LogDebug(id + " does not have any custom models or custom textures defined");
            }
            return true;
        }
        return false;
    }

    private boolean checkForLoop(Map<ResourceLocation, UnbakedVariant> existingVariants, ResourceLocation myID, LoopData loop) {
        if (this.completelyInvalid) {
            return true;
        }
        if (loop.checkAndAdd(myID, this)) {
            return true;
        }
        if (this.parent != null && !existingVariants.containsKey(this.parent)) {
            this.completelyInvalid = true;
            return true;
        }
        return false;
    }

    public ModelVariant bake(ResourceLocation id, TargetSelectorHelper targetSelectorHelper) {
        if (this.isInvalid()) {
            throw new IllegalStateException("Cannot bake an invalid UnbakedVariant");
        }
        List<ResourceLocation> targets = this.getTargets();
        boolean itemVariant = this.isItemVariant();
        if (this.isItemVariant()) {
            targetSelectorHelper.lookupItems(this.getTargetSelectors(), targets, this.getModels().size());
        } else {
            targetSelectorHelper.lookupBlocks(this.getTargetSelectors(), targets, this.getModels().size());
        }
        HashMap<ResourceLocation, Object> properties = new HashMap<ResourceLocation, Object>();
        UnbakedVariant.mergeProperties(this, properties);
        return new ModelVariant(targets, this.getName(), this.getItemModel(), this.getModels(), this.getTextureOverrides(), properties, itemVariant);
    }

    private static void mergeProperties(UnbakedVariant variant, Map<ResourceLocation, Object> data) {
        if (variant.parentVariant != null) {
            UnbakedVariant.mergeProperties(variant.parentVariant, data);
        }
        data.putAll(variant.properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void addTarget(List<ResourceLocation> targets, ResourceLocation target) {
        if (targets.contains(target)) {
            return;
        }
        targets.add(target);
    }

    private record LoopData(List<ResourceLocation> ids, List<UnbakedVariant> variants) {
        LoopData(ResourceLocation firstID, UnbakedVariant firstVariant) {
            this(Lists.newArrayList((Object[])new ResourceLocation[]{firstID}), Lists.newArrayList((Object[])new UnbakedVariant[]{firstVariant}));
        }

        private boolean optional() {
            return this.variants.get((int)(this.variants.size() - 1)).optional;
        }

        <T extends Throwable> boolean checkAndAdd(ResourceLocation id, UnbakedVariant variant) {
            if (this.ids.contains(id)) {
                return true;
            }
            this.ids.add(id);
            this.variants.add(variant);
            return false;
        }
    }

    public static class Builder {
        @Nullable
        private ResourceLocation parent;
        private final List<ResourceLocation> targets = new ArrayList<ResourceLocation>();
        private final List<String> selectorTargets = new ArrayList<String>();
        @Nullable
        private Component name;
        private ResourceLocation item = null;
        private final List<ResourceLocation> models = new ArrayList<ResourceLocation>();
        private final Map<String, ResourceLocation> textureOverrides = new HashMap<String, ResourceLocation>();
        private final Map<ResourceLocation, Object> properties = new HashMap<ResourceLocation, Object>();
        private boolean itemVariant = false;
        private boolean dummy = false;
        private boolean optional = false;

        private Builder() {
            VariantProperty.confirmRegistration();
        }

        public Builder withParent(ResourceLocation parent) {
            this.parent = parent;
            return this;
        }

        public Builder withTarget(Supplier<? extends ItemLike> target) {
            return this.withTarget(target.get().m_5456_());
        }

        public Builder withTarget(Item item) {
            return this.withTarget(ForgeRegistries.ITEMS.getKey((Object)item));
        }

        public Builder withTarget(Block block) {
            return this.withTarget(ForgeRegistries.BLOCKS.getKey((Object)block));
        }

        public Builder withTarget(ResourceLocation target) {
            if (!this.targets.contains(target)) {
                this.targets.add(target);
            }
            return this;
        }

        public Builder withSelectorTarget(String selectorTarget) {
            if (!this.selectorTargets.contains(selectorTarget)) {
                this.selectorTargets.add(selectorTarget);
            }
            return this;
        }

        public Builder withName(Component name) {
            this.name = name;
            return this;
        }

        public Builder withItem(ResourceLocation item) {
            this.item = item;
            return this;
        }

        public Builder withModel(ResourceLocation ... model) {
            this.models.addAll(Lists.newArrayList((Object[])model));
            return this;
        }

        public Builder withTexture(String textureKey, ResourceLocation texture) {
            this.textureOverrides.put(textureKey, texture);
            return this;
        }

        public <T> Builder withProperty(VariantProperty<T> property, T value) {
            this.properties.put(property.getID(), value);
            return this;
        }

        public <T> Builder withProperty(VariantPropertyWithDefault<T> property) {
            this.properties.put(property.getID(), property.getBuilderDefault());
            return this;
        }

        public Builder asItemVariant() {
            this.itemVariant = true;
            return this;
        }

        public Builder asDummy() {
            this.dummy = true;
            return this;
        }

        public Builder asOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public UnbakedVariant build() {
            return new UnbakedVariant(this.parent, this.targets, this.selectorTargets, this.name, this.item, this.models, this.textureOverrides, this.properties, this.itemVariant, this.dummy, this.optional);
        }
    }
}

