/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelHelper;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.mixin.client.ModelBakeryAccessor;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VariantModelBakery {
    private static final Map<String, String> BUILTIN_MODELS = Map.of("missing", ModelBakery.f_119231_);
    private final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private final Map<ResourceLocation, BlockModel> modelResources;
    private final Set<ResourceLocation> loadingStack = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, UnbakedModel> unbakedCache = new HashMap<ResourceLocation, UnbakedModel>();
    private final Map<ResourceLocation, List<ModelBakery.LoadedJson>> blockStates;
    private final Map<ResourceLocation, List<ResourceLocation>> defaultModels = new HashMap<ResourceLocation, List<ResourceLocation>>();
    private final Map<ModelCacheKey, UnbakedModel> topLevelModels = new HashMap<ModelCacheKey, UnbakedModel>();
    private final Map<ModelCacheKey, BakedModel> bakedTopLevelModels = new HashMap<ModelCacheKey, BakedModel>();
    private final Multimap<ModelCacheKey, VariantModelLocation> keyToVariantLocation = HashMultimap.create();
    private final UnbakedModel missingModel;

    public int getBakedModelCount() {
        return this.bakedTopLevelModels.size();
    }

    public final Map<VariantModelLocation, BakedModel> getBakedTopLevelModels() {
        HashMap result = new HashMap();
        Map keyCollectionMap = this.keyToVariantLocation.asMap();
        this.bakedTopLevelModels.forEach((key, model) -> {
            for (VariantModelLocation modelLocation : (Collection)keyCollectionMap.getOrDefault(key, new ArrayList())) {
                result.put(modelLocation, model);
            }
        });
        return ImmutableMap.copyOf(result);
    }

    public VariantModelBakery(BlockColors blockColors, ProfilerFiller profilerFiller, Map<ResourceLocation, BlockModel> modelResources, Map<ResourceLocation, List<ModelBakery.LoadedJson>> blockStates, Map<ResourceLocation, ModelVariant> variants) {
        this.modelResources = new HashMap<ResourceLocation, BlockModel>(modelResources);
        this.blockStates = blockStates;
        profilerFiller.m_6180_("missing_model");
        try {
            this.missingModel = this.loadBlockModel((ResourceLocation)ModelBakery.f_119230_);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading missing model!", e);
        }
        profilerFiller.m_6182_("variant models");
        variants.forEach((id, variant) -> {
            LightmansCurrency.LogDebug("Generating and loading models for variant " + id);
            for (ResourceLocation target : variant.getTargets()) {
                ModelProperties properties = ModelProperties.collectProperties(variant, target);
                if (properties != null) {
                    int max = properties.requiredModels();
                    int rotatable = properties.modelsFromBlockState();
                    boolean isRotatable = properties.isRotatable();
                    if (variant.getItemModel() != null) {
                        this.loadModel((ModelVariant)variant, (ResourceLocation)id, variant.getItemModel(), -1, properties.target(), false);
                    } else {
                        this.loadModel((ModelVariant)variant, (ResourceLocation)id, properties.target().m_246208_("item/"), -1, properties.target(), false);
                    }
                    if (variant.hasBlockModels()) {
                        for (int i = 0; i < max; ++i) {
                            this.loadModel((ModelVariant)variant, (ResourceLocation)id, variant.getBlockModels().get(i), i, properties.target(), isRotatable && i < rotatable);
                        }
                        continue;
                    }
                    if (properties.requiredModels <= 0) continue;
                    List<ResourceLocation> models = this.getDefaultModels(properties);
                    max = Math.min(max, models.size());
                    for (int i = 0; i < max; ++i) {
                        this.loadModel((ModelVariant)variant, (ResourceLocation)id, models.get(i), i, properties.target(), isRotatable && i < rotatable);
                    }
                    continue;
                }
                if (variant.isItemVariant()) {
                    LightmansCurrency.LogWarning("Unable to set up variant '" + id + "' for target " + target + " as it is not a valid variant item.");
                    continue;
                }
                LightmansCurrency.LogWarning("Unable to set up variant '" + id + "' for target " + target + " as it is not a valid variant block.");
            }
        });
        profilerFiller.m_7238_();
        profilerFiller.m_6182_("resolve_parents");
        this.topLevelModels.values().forEach(model -> model.m_5500_(this::getModel));
        profilerFiller.m_7238_();
        LightmansCurrency.LogDebug("Loaded " + this.topLevelModels.size() + " models for variant use");
    }

    public void bakeModels(BiFunction<String, Material, TextureAtlasSprite> textureGetter) {
        this.topLevelModels.forEach((id, unbakedModel) -> {
            BakedModel bakedmodel = null;
            try {
                bakedmodel = new VariantModelBaker((ModelCacheKey)id, textureGetter).bakeFromKey((ModelCacheKey)id, (UnbakedModel)unbakedModel, (ModelState)BlockModelRotation.X0_Y0);
            }
            catch (Exception e) {
                LightmansCurrency.LogWarning("Unable to bake model: '" + id + "'", e);
            }
            if (bakedmodel != null) {
                this.bakedTopLevelModels.put((ModelCacheKey)id, Objects.requireNonNull(bakedmodel));
            } else {
                LightmansCurrency.LogWarning("Variant Model " + id + " returned null during the baking process");
            }
        });
    }

    private List<ResourceLocation> getDefaultModels(ModelProperties properties) {
        ResourceLocation target = properties.target();
        if (this.defaultModels.containsKey(target)) {
            return this.defaultModels.get(target);
        }
        List<ResourceLocation> defaultModels = VariantModelHelper.getDefaultModels(properties, this.blockStates, ModelBakeryAccessor::runPredicate);
        this.defaultModels.put(target, defaultModels);
        return defaultModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnbakedModel getModel(ResourceLocation model) {
        if (this.unbakedCache.containsKey(model)) {
            return this.unbakedCache.get(model);
        }
        if (this.loadingStack.contains(model)) {
            throw new IllegalStateException("Circular reference while loading " + model);
        }
        this.loadingStack.add(model);
        while (!this.loadingStack.isEmpty()) {
            ResourceLocation resourcelocation = this.loadingStack.iterator().next();
            try {
                if (this.unbakedCache.containsKey(resourcelocation)) continue;
                BlockModel unbakedmodel = this.loadBlockModel(resourcelocation);
                this.unbakedCache.put(resourcelocation, (UnbakedModel)unbakedmodel);
                this.loadingStack.addAll(unbakedmodel.m_7970_());
            }
            catch (Exception e) {
                this.unbakedCache.put(resourcelocation, this.missingModel);
            }
            finally {
                this.loadingStack.remove(resourcelocation);
            }
        }
        return this.unbakedCache.getOrDefault(model, this.missingModel);
    }

    private BlockModel loadBlockModel(ResourceLocation location) throws IOException {
        String s = location.m_135815_();
        if ("builtin/generated".equals(s)) {
            return ModelBakery.f_119232_;
        }
        if ("builtin/entity".equals(s)) {
            return ModelBakery.f_119233_;
        }
        if (s.startsWith("builtin/")) {
            String s1 = s.substring("builtin/".length());
            String s2 = BUILTIN_MODELS.get(s1);
            if (s2 == null) {
                throw new FileNotFoundException(location.toString());
            }
            StringReader reader = new StringReader(s2);
            BlockModel blockmodel1 = BlockModel.m_111461_((Reader)reader);
            blockmodel1.f_111416_ = location.toString();
            return blockmodel1;
        }
        ResourceLocation resourcelocation = ModelBakery.f_244378_.m_245698_(location);
        BlockModel blockmodel = this.modelResources.get(resourcelocation);
        if (blockmodel == null) {
            throw new FileNotFoundException(resourcelocation.toString());
        }
        blockmodel.f_111416_ = location.toString();
        return blockmodel;
    }

    private void loadModel(ModelVariant variant, ResourceLocation variantID, ResourceLocation model, int modelIndex, ResourceLocation target, boolean rotatable) {
        ResourceLocation cacheVariant = null;
        if (variant.hasTextureOverrides()) {
            cacheVariant = variantID;
            ResourceLocation newModelID = VersionUtil.modResource(variantID.m_135827_(), "lc_model_variants/" + variantID.m_135815_() + "/" + modelIndex);
            VariantModelHelper.createCustomBlockModel(model, this.modelResources, variant.getTextureOverrides(), newModelID);
            model = newModelID;
        }
        if (rotatable) {
            for (int yRot = 0; yRot < 360; yRot += 90) {
                ModelCacheKey key = new ModelCacheKey(model, cacheVariant, yRot);
                VariantModelLocation modelLocation = VariantModelLocation.rotatable(variantID, target, modelIndex, yRot);
                UnbakedModel temp = this.topLevelModels.get(key);
                if (temp == null) {
                    temp = new MultiVariant((List)Lists.newArrayList((Object[])new Variant[]{new Variant(model, BlockModelRotation.m_119153_((int)0, (int)yRot).m_6189_(), false, 1)}));
                    this.topLevelModels.put(key, temp);
                }
                this.keyToVariantLocation.put((Object)key, (Object)modelLocation);
            }
        } else {
            ModelCacheKey key = new ModelCacheKey(model, cacheVariant, 0);
            VariantModelLocation modelLocation = VariantModelLocation.basic(variantID, target, modelIndex);
            UnbakedModel temp = this.topLevelModels.get(key);
            if (temp == null) {
                ResourceLocation fileID = ModelBakery.f_244378_.m_245698_(model);
                temp = this.getModel(model);
                this.topLevelModels.put(key, temp);
            }
            this.keyToVariantLocation.put((Object)key, (Object)modelLocation);
        }
    }

    public record ModelProperties(int requiredModels, int modelsFromBlockState, boolean isRotatable, ResourceLocation target, Function<Integer, ResourceLocation> defaultModelSource, Function<BlockState, Integer> stateIndexLookup) {
        @Nullable
        private static ModelProperties collectProperties(ModelVariant variant, ResourceLocation target) {
            if (variant.isItemVariant()) {
                IVariantItem item = VariantProvider.getVariantItem((Item)ForgeRegistries.ITEMS.getValue(target));
                if (item != null) {
                    return new ModelProperties(item.requiredModels(), 0, false, item.getItemID(), item::getDefaultModel, s -> -1);
                }
            } else {
                IVariantBlock block = VariantProvider.getVariantBlock((Block)ForgeRegistries.BLOCKS.getValue(target));
                if (block != null) {
                    return new ModelProperties(block.requiredModels(), block.modelsFromBlockState(), block.isRotatable(), block.getBlockID(), block::getCustomDefaultModel, block::getModelIndex);
                }
            }
            return null;
        }
    }

    private record ModelCacheKey(ResourceLocation model, @Nullable ResourceLocation variant, int yRot) {
    }

    private class VariantModelBaker
    implements ModelBaker {
        private final Function<Material, TextureAtlasSprite> textureGetter = material -> (TextureAtlasSprite)textureGetter.apply(modelLocation.toString(), (Material)material);

        VariantModelBaker(ModelCacheKey modelLocation, BiFunction<String, Material, TextureAtlasSprite> textureGetter) {
        }

        public UnbakedModel m_245361_(ResourceLocation location) {
            return VariantModelBakery.this.getModel(location);
        }

        @Nullable
        public BakedModel m_245240_(ResourceLocation location, ModelState transform) {
            return this.bake(location, transform, this.textureGetter);
        }

        @Nullable
        public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
            BlockModel blockModel;
            UnbakedModel unbakedmodel = this.m_245361_(location);
            if (unbakedmodel instanceof BlockModel && (blockModel = (BlockModel)unbakedmodel).m_111490_() == ModelBakery.f_119232_) {
                return VariantModelBakery.this.ITEM_MODEL_GENERATOR.m_111670_(sprites, blockModel).m_111449_((ModelBaker)this, blockModel, sprites, state, location, false);
            }
            return unbakedmodel.m_7611_((ModelBaker)this, sprites, state, location);
        }

        public BakedModel bakeFromKey(ModelCacheKey key, UnbakedModel model, ModelState state) {
            BlockModel blockModel;
            if (model instanceof BlockModel && (blockModel = (BlockModel)model).m_111490_() == ModelBakery.f_119232_) {
                return VariantModelBakery.this.ITEM_MODEL_GENERATOR.m_111670_(this.textureGetter, blockModel).m_111449_((ModelBaker)this, blockModel, this.textureGetter, state, key.model, false);
            }
            return model.m_7611_((ModelBaker)this, this.textureGetter, state, key.model);
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return this.textureGetter;
        }
    }
}

