/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantPropertyWithDefault;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record ShowInCreative(boolean show, boolean locked, List<ResourceLocation> targets) {
    public static final ShowInCreative FALSE = new ShowInCreative(false, false, (List<ResourceLocation>)ImmutableList.of());
    public static final ShowInCreative TRUE = new ShowInCreative(true, false, (List<ResourceLocation>)ImmutableList.of());
    public static final ShowInCreative LOCKED = new ShowInCreative(true, true, (List<ResourceLocation>)ImmutableList.of());
    public static final VariantPropertyWithDefault<ShowInCreative> PROPERTY = new Property();

    public boolean showFor(IVariantItem item) {
        if (!this.show) {
            return false;
        }
        if (this.targets.isEmpty()) {
            return true;
        }
        return this.targets.contains(item.getItemID());
    }

    public ShowInCreative withTargets(List<ResourceLocation> targets) {
        return new ShowInCreative(this.show, this.locked, (List<ResourceLocation>)ImmutableList.copyOf(targets));
    }

    private static class Property
    extends VariantPropertyWithDefault<ShowInCreative> {
        private Property() {
        }

        @Override
        public ShowInCreative getMissingDefault() {
            return FALSE;
        }

        @Override
        public ShowInCreative getBuilderDefault() {
            return TRUE;
        }

        @Override
        public ShowInCreative parse(JsonElement element) throws JsonSyntaxException, ResourceLocationException {
            if (element.isJsonPrimitive()) {
                return GsonHelper.m_13877_((JsonElement)element, (String)this.getID().toString()) ? TRUE : FALSE;
            }
            JsonObject object = GsonHelper.m_13918_((JsonElement)element, (String)this.getID().toString());
            boolean locked = GsonHelper.m_13912_((JsonObject)object, (String)"locked");
            ArrayList<ResourceLocation> targets = new ArrayList<ResourceLocation>();
            if (object.has("targets")) {
                if (object.get("targets").isJsonPrimitive()) {
                    targets.add(VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)object, (String)"targets")));
                } else {
                    JsonArray targetList = GsonHelper.m_13933_((JsonObject)object, (String)"targets");
                    for (int i = 0; i < targetList.size(); ++i) {
                        targets.add(VersionUtil.parseResource(GsonHelper.m_13805_((JsonElement)targetList.get(i), (String)("targets[" + i + "]"))));
                    }
                }
            }
            return new ShowInCreative(true, locked, (List<ResourceLocation>)ImmutableList.copyOf(targets));
        }

        @Override
        public JsonElement write(Object value) {
            if (value instanceof ShowInCreative) {
                ShowInCreative sic = (ShowInCreative)value;
                if (sic.show && (sic.locked || !sic.targets.isEmpty())) {
                    JsonObject result = new JsonObject();
                    result.addProperty("locked", Boolean.valueOf(sic.locked));
                    if (sic.targets.size() == 1) {
                        result.addProperty("targets", sic.targets.get(0).toString());
                    } else if (!sic.targets.isEmpty()) {
                        JsonArray targetList = new JsonArray();
                        for (ResourceLocation t : sic.targets) {
                            targetList.add(t.toString());
                        }
                        result.add("targets", (JsonElement)targetList);
                    }
                    return result;
                }
                return new JsonPrimitive(Boolean.valueOf(sic.show));
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return new JsonPrimitive(bool);
            }
            throw new IllegalArgumentException("Value must be an ShowInCreative element!");
        }
    }
}

