/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperty;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TooltipInfo {
    public static final VariantProperty<TooltipInfo> PROPERTY = new TooltipInfoProperty();
    private final List<Component> tooltip;
    public final boolean drawOnSelection;
    public final boolean drawOnItem;
    public final boolean drawOnJade;

    public List<Component> getTooltip() {
        return new ArrayList<Component>(this.tooltip);
    }

    public TooltipInfo(Component tooltip) {
        this((List<Component>)ImmutableList.of((Object)tooltip), true, true, true);
    }

    public TooltipInfo(List<Component> tooltip) {
        this(tooltip, true, true, true);
    }

    public TooltipInfo(List<Component> tooltip, boolean drawOnSelection, boolean drawOnItem, boolean drawOnJade) {
        this.tooltip = ImmutableList.copyOf(tooltip);
        this.drawOnSelection = drawOnSelection;
        this.drawOnItem = drawOnItem;
        this.drawOnJade = drawOnJade;
    }

    public static TooltipInfo ofModifier(TextEntry modifier) {
        return TooltipInfo.ofModifier(modifier.get(new Object[0]));
    }

    public static TooltipInfo ofModifier(MutableComponent modifier) {
        return new TooltipInfo((Component)LCText.BLOCK_VARIANT_MODIFIER_LABEL.get(modifier.m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_AQUA})).m_130940_(ChatFormatting.GRAY));
    }

    private static class TooltipInfoProperty
    extends VariantProperty<TooltipInfo> {
        private TooltipInfoProperty() {
        }

        @Override
        public TooltipInfo parse(JsonElement element) throws JsonSyntaxException, ResourceLocationException {
            ArrayList<Component> tooltip;
            String elementName = this.getID().toString();
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)elementName);
            JsonElement tooltipElement = json.get("tooltip");
            if (tooltipElement == null) {
                GsonHelper.m_13933_((JsonObject)json, (String)"tooltip");
            }
            if (tooltipElement.isJsonObject() || tooltipElement.isJsonPrimitive()) {
                MutableComponent line = Component.Serializer.m_130691_((JsonElement)tooltipElement);
                tooltip = new ArrayList();
                tooltip.add((Component)line);
            } else {
                tooltip = new ArrayList<Component>();
                JsonArray tooltipArray = GsonHelper.m_13924_((JsonElement)tooltipElement, (String)"tooltip");
                for (int i = 0; i < tooltipArray.size(); ++i) {
                    MutableComponent line = Component.Serializer.m_130691_((JsonElement)tooltipArray.get(i));
                    tooltip.add((Component)line);
                }
            }
            boolean drawOnSelection = GsonHelper.m_13855_((JsonObject)json, (String)"selection", (boolean)true);
            boolean drawOnItem = GsonHelper.m_13855_((JsonObject)json, (String)"item", (boolean)true);
            boolean drawOnJade = GsonHelper.m_13855_((JsonObject)json, (String)"jade", (boolean)true);
            return new TooltipInfo(tooltip, drawOnSelection, drawOnItem, drawOnJade);
        }

        @Override
        public JsonElement write(Object value) {
            if (value instanceof TooltipInfo) {
                TooltipInfo data = (TooltipInfo)value;
                JsonObject json = new JsonObject();
                if (data.tooltip.size() == 1) {
                    json.add("tooltip", Component.Serializer.m_130716_((Component)data.tooltip.get(0)));
                } else {
                    JsonArray tooltipArray = new JsonArray();
                    for (Component line : data.tooltip) {
                        tooltipArray.add(Component.Serializer.m_130716_((Component)line));
                    }
                    json.add("tooltip", (JsonElement)tooltipArray);
                }
                json.addProperty("selection", Boolean.valueOf(data.drawOnSelection));
                json.addProperty("item", Boolean.valueOf(data.drawOnItem));
                json.addProperty("jade", Boolean.valueOf(data.drawOnJade));
                return json;
            }
            throw new IllegalArgumentException("Value must be a TooltipInfo element!");
        }
    }
}

