/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.cards;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.capability.money.CapabilityMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.common.items.cards.ATMCardMoneyHandler;
import io.github.lightman314.lightmanscurrency.common.items.colored.ColoredItem;
import io.github.lightman314.lightmanscurrency.common.menus.ATMCardMenu;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkHooks;

public class ATMCardItem
extends Item
implements ColoredItem,
IVariantItem {
    public ATMCardItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag tag) {
        return CapabilityMoneyHandler.createProvider(new ATMCardMoneyHandler(stack));
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("BankAccount")) {
            tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_NOT_LINKED.getWithStyle(ChatFormatting.GRAY));
        } else {
            BankReference reference = BankReference.load(tag.m_128469_("BankAccount")).flagAsClient();
            IBankAccount account = reference.get();
            if (account == null) {
                tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_NOT_LINKED.getWithStyle(ChatFormatting.GRAY));
            } else {
                int validation;
                tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_ACCOUNT.get(account.getName().m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
                int n = validation = tag.m_128441_("AccountValidation") ? tag.m_128451_("AccountValidation") : -1;
                if (!account.isCardValid(validation)) {
                    tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_LINK_INVALID.getWithStyle(ChatFormatting.RED));
                } else {
                    tooltip.add((Component)account.getBalanceText().m_130940_(ChatFormatting.GRAY));
                    tooltip.addAll(TooltipHelper.splitTooltips((Component)LCText.TOOLTIP_PAYMENT_CARD_USAGE.get(new Object[0]), ChatFormatting.GRAY));
                }
            }
            if (tag.m_128471_("CardLocked")) {
                tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_ACCOUNT_LOCKED.getWithStyle(ChatFormatting.GRAY));
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack card = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (QuarantineAPI.IsDimensionQuarantined(level)) {
                EasyText.sendMessage(player, (Component)LCText.MESSAGE_DIMENSION_QUARANTINED_BANK.getWithStyle(ChatFormatting.GOLD));
                return InteractionResultHolder.m_19090_((Object)card);
            }
            int inventorySlot = -1;
            for (int i = 0; i < player.m_150109_().m_6643_() && inventorySlot < 0; ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack != card) continue;
                inventorySlot = i;
            }
            if (inventorySlot >= 0) {
                int slot = inventorySlot;
                CompoundTag tag = card.m_41784_();
                if (tag.m_128471_("CardLocked") && !LCAdminMode.isAdminPlayer(player)) {
                    player.m_213846_((Component)LCText.MESSAGE_ATM_CARD_LOCKED.get(new Object[0]));
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)card);
                }
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)ATMCardMenu.getProvider(inventorySlot), b -> b.writeInt(slot));
            }
        }
        return InteractionResultHolder.m_19090_((Object)card);
    }
}

