/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.variant;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockValidator;
import io.github.lightman314.lightmanscurrency.common.menus.variant.VariantSelectMenu;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockVariantSelectMenu
extends VariantSelectMenu {
    private final BlockPos pos;
    private final Level level;
    private final IVariantBlock variantBlock;
    private final Block block;
    private int pendingClose = -1;
    private final List<Pair<BlockPos, Boolean>> pendingUpdates = new ArrayList<Pair<BlockPos, Boolean>>();

    public Block getBlock() {
        return this.block;
    }

    public IVariantBlock getVariantBlock() {
        return this.variantBlock;
    }

    public BlockVariantSelectMenu(int id, Inventory inventory, BlockPos pos) {
        super(ModMenus.VARIANT_SELECT_BLOCK.get(), id, inventory);
        this.pos = pos;
        this.level = inventory.f_35978_.m_9236_();
        this.block = this.level.m_8055_(this.pos).m_60734_();
        this.variantBlock = VariantProvider.getVariantBlock(this.block);
        if (this.variantBlock != null) {
            this.addValidator(BlockValidator.of(this.pos, this.block));
        } else {
            this.addValidator(() -> false);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected void changeVariant(@Nullable ResourceLocation variant) {
        BlockEntity blockEntity = this.level.m_7702_(this.pos);
        IVariantDataStorage data = IVariantDataStorage.get((BlockGetter)this.level, this.pos);
        if (data != null) {
            if (data.isVariantLocked() && !this.player.m_7500_()) {
                LightmansCurrency.LogDebug(this.player.m_7755_().getString() + " attempted to change the variant of a locked block!");
                return;
            }
            data.setVariant(variant);
            this.updateVariantState(this.level, this.pos, variant != null);
            this.pendingClose = 1;
        }
    }

    private void updateVariantState(Level level, BlockPos pos, boolean variant) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IWideBlock) {
            IWideBlock wideBlock = (IWideBlock)block;
            this.updateWideStates(wideBlock, level, pos, variant);
        } else {
            block = state.m_60734_();
            if (block instanceof IDeepBlock) {
                IDeepBlock deepBlock = (IDeepBlock)block;
                this.updateDeepStates(deepBlock, level, pos, variant);
            } else {
                block = state.m_60734_();
                if (block instanceof ITallBlock) {
                    ITallBlock tallBlock = (ITallBlock)block;
                    this.updateTallStates(tallBlock, level, pos, variant);
                } else {
                    this.updateSingleState(level, pos, variant);
                }
            }
        }
    }

    private void updateWideStates(IWideBlock wideBlock, Level level, BlockPos pos, boolean variant) {
        if (wideBlock instanceof IDeepBlock) {
            IDeepBlock deepBlock = (IDeepBlock)((Object)wideBlock);
            this.updateDeepStates(deepBlock, level, pos, variant);
            this.updateDeepStates(deepBlock, level, wideBlock.getOtherSide(pos, level.m_8055_(pos)), variant);
        } else if (wideBlock instanceof ITallBlock) {
            ITallBlock tallBlock = (ITallBlock)((Object)wideBlock);
            this.updateTallStates(tallBlock, level, pos, variant);
            this.updateTallStates(tallBlock, level, wideBlock.getOtherSide(pos, level.m_8055_(pos)), variant);
        } else {
            this.updateSingleState(level, pos, variant);
            pos = wideBlock.getOtherSide(pos, level.m_8055_(pos));
            this.updateSingleState(level, pos, variant);
        }
    }

    private void updateDeepStates(IDeepBlock deepBlock, Level level, BlockPos pos, boolean variant) {
        if (deepBlock instanceof ITallBlock) {
            ITallBlock tallBlock = (ITallBlock)((Object)deepBlock);
            this.updateTallStates(tallBlock, level, pos, variant);
            this.updateTallStates(tallBlock, level, deepBlock.getOtherDepth(pos, level.m_8055_(pos)), variant);
        } else {
            this.updateSingleState(level, pos, variant);
            pos = deepBlock.getOtherDepth(pos, level.m_8055_(pos));
            this.updateSingleState(level, pos, variant);
        }
    }

    private void updateTallStates(ITallBlock tallBlock, Level level, BlockPos pos, boolean variant) {
        this.updateSingleState(level, pos, variant);
        pos = tallBlock.getOtherHeight(pos, level.m_8055_(pos));
        this.updateSingleState(level, pos, variant);
    }

    private void updateSingleState(Level level, BlockPos pos, boolean variant) {
        this.updateSingleState(level, pos, variant, true);
    }

    private void updateSingleState(Level level, BlockPos pos, boolean variant, boolean allowTick) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this.block) {
            return;
        }
        if (variant == (Boolean)state.m_61143_((Property)IVariantBlock.VARIANT) && allowTick) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(!variant)));
            this.pendingUpdates.add((Pair<BlockPos, Boolean>)Pair.of((Object)pos, (Object)variant));
            LightmansCurrency.LogDebug("Scheduled tick at " + pos);
        } else {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(variant)));
        }
    }

    @Override
    @Nullable
    public ResourceLocation getSelectedVariant() {
        IVariantDataStorage data = IVariantDataStorage.get((BlockGetter)this.level, this.pos);
        if (data != null) {
            return data.getCurrentVariant();
        }
        return null;
    }

    private void sendUpdateModelMessage(BlockPos pos) {
        this.SendMessageToClient(this.builder().setBlockPos("UpdateModel", pos));
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public void m_6877_(Player player) {
        this.runPendingUpdates();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (this.pendingClose < 0) {
            return;
        }
        if (this.pendingClose-- < 1) {
            this.runPendingUpdates();
            this.player.m_6915_();
        }
    }

    private void runPendingUpdates() {
        for (Pair<BlockPos, Boolean> update : new ArrayList<Pair<BlockPos, Boolean>>(this.pendingUpdates)) {
            BlockState existingState = this.level.m_8055_((BlockPos)update.getFirst());
            LightmansCurrency.LogDebug("Executed tick at " + update.getFirst());
            this.updateSingleState(this.level, (BlockPos)update.getFirst(), (Boolean)update.getSecond(), false);
        }
        this.pendingUpdates.clear();
    }

    public static MenuProvider providerFor(BlockPos pos) {
        return new Provider(pos);
    }

    private record Provider(BlockPos pos) implements EasyMenuProvider
    {
        @Nullable
        public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
            return new BlockVariantSelectMenu(containerId, playerInventory, this.pos);
        }
    }
}

