/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.data;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemData {
    private final ItemStack stack;
    private final MutableComponent deprecatedName;
    private final String customName;

    public ItemData(ItemStack stack) {
        this(stack, null, "");
    }

    public ItemData(ItemStack stack, String customName) {
        this(stack, null, customName);
    }

    public ItemData(ItemStack stack, @Nullable MutableComponent deprecatedName, String customName) {
        this.stack = stack;
        this.deprecatedName = deprecatedName;
        this.customName = customName;
    }

    private ItemData(MutableComponent deprecatedName, int count) {
        this.stack = new ItemStack((ItemLike)Items.f_42127_, count);
        this.deprecatedName = deprecatedName;
        this.customName = "";
    }

    public MutableComponent getName() {
        if (this.deprecatedName != null) {
            return this.deprecatedName;
        }
        return this.customName.isEmpty() ? EasyText.empty().m_7220_(this.stack.m_41786_()) : EasyText.literal(this.customName);
    }

    public MutableComponent format() {
        return LCText.NOTIFICATION_ITEM_FORMAT.get(this.stack.m_41613_(), this.getName());
    }

    public MutableComponent formatWith(ItemData other) {
        return LCText.GUI_AND.get(this.format(), other.format());
    }

    public MutableComponent formatWith(MutableComponent other) {
        return LCText.GUI_AND.get(this.format(), other);
    }

    public static MutableComponent format(ItemData d1, ItemData d2) {
        if (d1.stack.m_41619_() && d2.stack.m_41619_()) {
            return EasyText.literal("ERROR");
        }
        if (d1.stack.m_41619_()) {
            return d2.format();
        }
        if (d2.stack.m_41619_()) {
            return d1.format();
        }
        return d1.formatWith(d2);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        tag.m_128359_("CustomName", this.customName);
        if (this.deprecatedName != null) {
            tag.m_128359_("DeprecatedName", Component.Serializer.m_130703_((Component)this.deprecatedName));
        }
        return tag;
    }

    public static ItemData load(CompoundTag tag) {
        if (tag.m_128441_("Empty")) {
            return new ItemData(ItemStack.f_41583_, "");
        }
        if (tag.m_128441_("Name")) {
            MutableComponent deprecatedName = Component.Serializer.m_130701_((String)tag.m_128461_("Name"));
            int count = tag.m_128451_("Count");
            return new ItemData(deprecatedName, count);
        }
        ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Stack"));
        String customName = tag.m_128461_("CustomName");
        MutableComponent deprecatedName = null;
        if (tag.m_128441_("DeprecatedName")) {
            deprecatedName = Component.Serializer.m_130701_((String)tag.m_128461_("DeprecatedName"));
        }
        return new ItemData(stack, deprecatedName, customName);
    }

    public boolean matches(ItemData other) {
        if (this.deprecatedName != null || other.deprecatedName != null) {
            return false;
        }
        return this.customName.equals(other.customName) && InventoryUtil.ItemsFullyMatch(this.stack, other.stack);
    }

    public static Component getItemNames(List<ItemData> items) {
        MutableComponent result = null;
        for (ItemData item : items) {
            if (result != null) {
                result = item.formatWith(result);
                continue;
            }
            result = item.format();
        }
        return result == null ? Component.m_237113_((String)"ERROR") : result;
    }
}

