/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BankInterestNotification
extends SingleLineNotification {
    public static final NotificationType<BankInterestNotification> TYPE = new NotificationType(VersionUtil.lcResource("bank_interest"), BankInterestNotification::new);
    protected Component accountName;
    protected MoneyValue amount;

    protected BankInterestNotification() {
    }

    protected BankInterestNotification(Component accountName, MoneyValue amount) {
        this.accountName = accountName;
        this.amount = amount;
    }

    public static Supplier<Notification> create(Component accountName, MoneyValue amount) {
        return () -> new BankInterestNotification(accountName, amount);
    }

    protected NotificationType<BankInterestNotification> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    public Component getMessage() {
        return LCText.NOTIFICATION_BANK_INTEREST.get(this.amount.getText());
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128365_("Amount", (Tag)this.amount.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        this.amount = MoneyValue.safeLoad(compound, "Amount");
    }

    @Override
    protected boolean canMerge(Notification other) {
        return false;
    }
}

