/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OutOfStockNotification
extends SingleLineNotification {
    public static final NotificationType<OutOfStockNotification> TYPE = new NotificationType(VersionUtil.lcResource("out_of_stock"), OutOfStockNotification::new);
    TraderCategory traderData;
    int tradeSlot;

    private OutOfStockNotification() {
    }

    protected OutOfStockNotification(TraderCategory traderData, int tradeIndex) {
        this.traderData = traderData;
        this.tradeSlot = tradeIndex + 1;
    }

    public static Supplier<Notification> create(TraderCategory trader, int tradeIndex) {
        return () -> new OutOfStockNotification(trader, tradeIndex);
    }

    protected NotificationType<OutOfStockNotification> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    public Component getMessage() {
        return this.tradeSlot > 0 ? LCText.NOTIFICATION_TRADER_OUT_OF_STOCK.get(this.traderData.getTooltip(), this.tradeSlot) : LCText.NOTIFICATION_TRADER_OUT_OF_STOCK_INDEXLESS.get(new Object[0]);
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeSlot", this.tradeSlot);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeSlot = compound.m_128451_("TradeSlot");
    }

    @Override
    protected boolean canMerge(Notification other) {
        return false;
    }
}

