/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PaygateNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<PaygateNotification> TYPE = new NotificationType(VersionUtil.lcResource("paygate_trade"), PaygateNotification::new);
    TraderCategory traderData;
    long ticketID = Long.MIN_VALUE;
    boolean usedPass = false;
    MoneyValue cost = MoneyValue.empty();
    int duration = 0;
    String customer;

    private PaygateNotification() {
    }

    protected PaygateNotification(PaygateTradeData trade, MoneyValue cost, boolean usedPass, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.usedPass = usedPass;
        this.ticketID = trade.getTicketID();
        if (trade.isTicketTrade()) {
            this.ticketID = trade.getTicketID();
        } else {
            this.cost = cost;
        }
        this.duration = trade.getDuration();
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> createTicket(PaygateTradeData trade, boolean usedPass, PlayerReference customer, TraderCategory traderData) {
        return () -> new PaygateNotification(trade, MoneyValue.empty(), usedPass, customer, traderData, MoneyValue.empty());
    }

    public static Supplier<Notification> createMoney(PaygateTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        return () -> new PaygateNotification(trade, cost, false, customer, traderData, taxesPaid);
    }

    protected NotificationType<PaygateNotification> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    public Component getNormalMessage() {
        if (this.ticketID >= -1L) {
            if (this.usedPass) {
                return LCText.NOTIFICATION_TRADE_PAYGATE_PASS.get(this.customer, this.ticketID, PaygateTradeData.formatDurationShort(this.duration));
            }
            return LCText.NOTIFICATION_TRADE_PAYGATE_TICKET.get(this.customer, this.ticketID, PaygateTradeData.formatDurationShort(this.duration));
        }
        return LCText.NOTIFICATION_TRADE_PAYGATE_MONEY.get(this.customer, this.cost.getText(), PaygateTradeData.formatDurationShort(this.duration));
    }

    @Override
    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("Duration", this.duration);
        if (this.ticketID >= -1L) {
            compound.m_128356_("TicketID", this.ticketID);
            compound.m_128379_("UsedPass", this.usedPass);
        } else {
            compound.m_128365_("Price", (Tag)this.cost.save());
        }
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.duration = compound.m_128451_("Duration");
        if (compound.m_128441_("TicketID")) {
            this.ticketID = compound.m_128454_("TicketID");
        } else if (compound.m_128441_("Price")) {
            this.cost = MoneyValue.safeLoad(compound, "Price");
        }
        if (compound.m_128441_("UsedPass")) {
            this.usedPass = compound.m_128471_("UsedPass");
        }
        this.customer = compound.m_128461_("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof PaygateNotification) {
            PaygateNotification pn = (PaygateNotification)other;
            if (!pn.traderData.matches(this.traderData)) {
                return false;
            }
            if (pn.ticketID != this.ticketID) {
                return false;
            }
            if (pn.usedPass != this.usedPass) {
                return false;
            }
            if (pn.duration != this.duration) {
                return false;
            }
            if (pn.cost.equals(this.cost)) {
                return false;
            }
            if (!pn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(pn);
        }
        return false;
    }
}

