/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class RandomTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("random_selection");
    public static final Serializer SERIALIZER = new Serializer();
    protected final ItemStack price1;
    protected final ItemStack price2;
    protected final List<ItemStack> sellItemOptions;
    protected final TagKey<Item> sellItemTag;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;

    public static RandomTrade build(ItemStack price, List<? extends ItemLike> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
        return RandomTrade.build(price, ItemStack.f_41583_, sellItemOptions, maxTrades, xpValue, priceMult);
    }

    public static RandomTrade build(ItemStack price1, ItemStack price2, List<? extends ItemLike> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
        return new RandomTrade(price1, price2, RandomTrade.convertItemList(sellItemOptions), null, maxTrades, xpValue, priceMult);
    }

    public static RandomTrade build(ItemStack price1, TagKey<Item> itemTag, int maxTrades, int xpValue, float priceMult) {
        return RandomTrade.build(price1, ItemStack.f_41583_, itemTag, maxTrades, xpValue, priceMult);
    }

    public static RandomTrade build(ItemStack price1, ItemStack price2, TagKey<Item> itemTag, int maxTrades, int xpValue, float priceMult) {
        return new RandomTrade(price1, price2, null, itemTag, maxTrades, xpValue, priceMult);
    }

    public RandomTrade(ItemStack price1, ItemStack price2, List<ItemStack> sellItemOptions, TagKey<Item> itemTag, int maxTrades, int xpValue, float priceMult) {
        this.price1 = price1;
        this.price2 = price2;
        this.sellItemOptions = sellItemOptions;
        this.sellItemTag = itemTag;
        this.maxTrades = maxTrades;
        this.xp = xpValue;
        this.priceMult = priceMult;
    }

    private static List<ItemStack> convertItemList(Iterable<? extends ItemLike> array) {
        ArrayList<ItemStack> options = new ArrayList<ItemStack>();
        for (ItemLike itemLike : array) {
            ItemStack stack = new ItemStack(itemLike);
            if (stack.m_41619_()) continue;
            options.add(stack);
        }
        return options;
    }

    public MerchantOffer m_213663_(@NotNull Entity trader, @Nonnull RandomSource rand) {
        ItemStack sellItem = this.getRandomItem(rand);
        if (sellItem == null) {
            return null;
        }
        return new MerchantOffer(this.price1, this.price2, sellItem, this.maxTrades, this.xp, this.priceMult);
    }

    private ItemStack getRandomItem(@Nonnull RandomSource rand) {
        if (this.sellItemOptions != null) {
            int index = rand.m_188503_(this.sellItemOptions.size());
            return this.sellItemOptions.get(index);
        }
        if (this.sellItemTag != null) {
            Optional result = ForgeRegistries.ITEMS.tags().getTag(this.sellItemTag).getRandomElement(rand);
            return result.map(ItemStack::new).orElse(null);
        }
        return null;
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public JsonObject serializeInternal(JsonObject json, VillagerTrades.ItemListing trade) {
            if (trade instanceof RandomTrade) {
                RandomTrade t = (RandomTrade)trade;
                json.add("Price", (JsonElement)FileUtil.convertItemStack(t.price1));
                if (!t.price2.m_41619_()) {
                    json.add("Price2", (JsonElement)FileUtil.convertItemStack(t.price2));
                }
                if (t.sellItemOptions != null) {
                    JsonArray sellItems = new JsonArray();
                    for (ItemStack item : t.sellItemOptions) {
                        sellItems.add((JsonElement)FileUtil.convertItemStack(item));
                    }
                    json.add("Sell", (JsonElement)sellItems);
                } else if (t.sellItemTag != null) {
                    json.addProperty("SellTag", t.sellItemTag.f_203868_().toString());
                }
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        public VillagerTrades.ItemListing deserialize(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
            ItemStack price1 = FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Price"));
            ItemStack price2 = json.has("Price2") ? FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Price2")) : ItemStack.f_41583_;
            ArrayList<ItemStack> sellItems = null;
            if (json.has("Sell")) {
                sellItems = new ArrayList<ItemStack>();
                JsonArray sellItemsArray = GsonHelper.m_13933_((JsonObject)json, (String)"Sell");
                for (int i = 0; i < sellItemsArray.size(); ++i) {
                    sellItems.add(FileUtil.parseItemStack(sellItemsArray.get(i).getAsJsonObject()));
                }
            }
            TagKey sellTag = null;
            if (json.has("SellTag")) {
                sellTag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"SellTag")));
            }
            if (sellTag == null && sellItems == null) {
                throw new JsonSyntaxException("Missing 'Sell' or 'SellTag' key");
            }
            int maxTrades = GsonHelper.m_13927_((JsonObject)json, (String)"MaxTrades");
            int xp = GsonHelper.m_13927_((JsonObject)json, (String)"XP");
            float priceMult = GsonHelper.m_13915_((JsonObject)json, (String)"PriceMult");
            return new RandomTrade(price1, price2, sellItems, (TagKey<Item>)sellTag, maxTrades, xp, priceMult);
        }
    }
}

