/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface TraderPeripheralSource {
    @Nullable
    public LCPeripheral tryCreate(TraderBlockEntity<?> var1);

    @Nullable
    public LCPeripheral tryCreate(TraderData var1);

    public static TraderPeripheralSource simple(Function<TraderBlockEntity<?>, LCPeripheral> blockSource, Function<TraderData, LCPeripheral> dataSource) {
        return new Simple(blockSource, dataSource);
    }

    public static TraderPeripheralSource blockOnly(Function<TraderBlockEntity<?>, LCPeripheral> blockSource) {
        return new Simple(blockSource, d -> null);
    }

    public static TraderPeripheralSource dataOnly(Function<TraderData, LCPeripheral> dataSource) {
        return new Simple(b -> null, dataSource);
    }

    public static class Simple
    implements TraderPeripheralSource {
        private final Function<TraderBlockEntity<?>, LCPeripheral> blockSource;
        private final Function<TraderData, LCPeripheral> traderSource;

        private Simple(Function<TraderBlockEntity<?>, LCPeripheral> blockSource, Function<TraderData, LCPeripheral> traderSource) {
            this.blockSource = blockSource;
            this.traderSource = traderSource;
        }

        @Override
        @Nullable
        public LCPeripheral tryCreate(TraderBlockEntity<?> be) {
            return this.blockSource.apply(be);
        }

        @Override
        @Nullable
        public LCPeripheral tryCreate(TraderData trader) {
            return this.traderSource.apply(trader);
        }
    }
}

