/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.integration.create.attributes.LCItemAttributes;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WalletAttributeType
implements ItemAttributeType {
    private static final WalletAttribute PICKUP_ABILITY = new WalletAttribute(AbilityType.PICKUP);
    private static final WalletAttribute EXCHANGE_ABILITY = new WalletAttribute(AbilityType.EXCHANGE);
    private static final WalletAttribute BANK_ABILITY = new WalletAttribute(AbilityType.BANK);

    public ItemAttribute createAttribute() {
        return new WalletAttribute(AbilityType.PICKUP);
    }

    public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        ArrayList<ItemAttribute> result = new ArrayList<ItemAttribute>();
        Item item = stack.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem wallet = (WalletItem)item;
            if (WalletItem.CanExchange(wallet)) {
                result.add(EXCHANGE_ABILITY);
            }
            if (WalletItem.CanPickup(wallet)) {
                result.add(PICKUP_ABILITY);
            }
            if (WalletItem.HasBankAccess(wallet)) {
                result.add(BANK_ABILITY);
            }
        }
        return result;
    }

    public static class WalletAttribute
    implements ItemAttribute {
        private AbilityType ability;

        public WalletAttribute(AbilityType ability) {
            this.ability = ability;
        }

        public boolean appliesTo(ItemStack stack, Level world) {
            Item item = stack.m_41720_();
            if (item instanceof WalletItem) {
                WalletItem wallet = (WalletItem)item;
                return switch (this.ability) {
                    default -> throw new IncompatibleClassChangeError();
                    case AbilityType.PICKUP -> WalletItem.CanPickup(wallet);
                    case AbilityType.EXCHANGE -> WalletItem.CanExchange(wallet);
                    case AbilityType.BANK -> WalletItem.HasBankAccess(wallet);
                };
            }
            return false;
        }

        public ItemAttributeType getType() {
            return LCItemAttributes.WALLET_ATTRIBUTE.get();
        }

        public void save(CompoundTag tag) {
            tag.m_128359_("ability", this.ability.name());
        }

        public void load(CompoundTag tag) {
            this.ability = (AbilityType)EnumUtil.enumFromString((String)tag.m_128461_("ability"), (Enum[])AbilityType.values(), (Enum)AbilityType.PICKUP);
        }

        public String getTranslationKey() {
            return "lightmanscurrency.wallet_ability." + this.ability.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum AbilityType {
        EXCHANGE,
        PICKUP,
        BANK;

    }
}

