/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.curios;

import io.github.lightman314.lightmanscurrency.common.items.PortableATMItem;
import io.github.lightman314.lightmanscurrency.common.items.PortableTerminalItem;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCuriosInternal;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LCCurios {
    public static boolean isLoaded() {
        return ModList.get().isLoaded("curios");
    }

    public static boolean hasWalletSlot(LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasWalletSlot(entity);
    }

    public static ItemStack getCuriosWalletItem(LivingEntity entity) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getCuriosWalletItem(entity) : ItemStack.f_41583_;
    }

    public static ItemStack getVisibleCuriosWalletItem(LivingEntity entity) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getVisibleCuriosWalletItem(entity) : ItemStack.f_41583_;
    }

    public static void setCuriosWalletItem(LivingEntity entity, ItemStack stack) {
        if (LCCurios.isLoaded()) {
            LCCuriosInternal.setCuriosWalletItem(entity, stack);
        }
    }

    public static boolean getCuriosWalletVisibility(LivingEntity entity) {
        return LCCurios.isLoaded() && LCCuriosInternal.getCuriosWalletVisibility(entity);
    }

    public static boolean hasItem(LivingEntity entity, Predicate<ItemStack> check) {
        return LCCurios.isLoaded() && LCCuriosInternal.hasItem(entity, check);
    }

    @Nullable
    public static Item lookupItem(LivingEntity entity, Predicate<ItemStack> check) {
        return !LCCurios.isLoaded() ? null : LCCuriosInternal.lookupItem(entity, check);
    }

    @Nullable
    public static Item lookupPortableTerminal(LivingEntity entity) {
        return LCCurios.lookupItem(entity, stack -> stack.m_41720_() instanceof PortableTerminalItem);
    }

    @Nullable
    public static Item lookupPortableATM(LivingEntity entity) {
        return LCCurios.lookupItem(entity, stack -> stack.m_41720_() instanceof PortableATMItem);
    }

    @Nullable
    public static ItemStack getRandomItem(LivingEntity entity, Predicate<ItemStack> check) {
        return LCCurios.isLoaded() ? LCCuriosInternal.getRandomItem(entity, check) : null;
    }

    public static DropRule getWalletDropRules(LivingEntity entity) {
        if (LCCurios.isLoaded()) {
            return LCCuriosInternal.getWalletDropRules(entity);
        }
        return DropRule.DEFAULT;
    }

    @Nullable
    public static ICapabilityProvider createWalletProvider(ItemStack stack) {
        if (LCCurios.isLoaded()) {
            return LCCuriosInternal.createWalletProvider(stack);
        }
        return null;
    }

    public static enum DropRule {
        DEFAULT,
        KEEP,
        DROP,
        DESTROY;


        public boolean shouldKeep(LivingEntity entity) {
            return this == KEEP || this == DEFAULT && entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_);
        }

        public boolean shouldDestroy() {
            return this == DESTROY;
        }
    }
}

