/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.ftb_filter.filter;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import io.github.lightman314.lightmanscurrency.api.filter.IItemTradeFilter;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.integration.ftb_filter.LCFTBFilterSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class FTBFilter
implements IItemTradeFilter {
    public static FTBFilter INSTANCE = new FTBFilter();

    private FTBFilter() {
    }

    @Override
    @Nullable
    public Predicate<ItemStack> getFilter(ItemStack stack) {
        if (LCFTBFilterSystem.hasFilter(stack)) {
            return other -> FTBFilterSystemAPI.api().doesFilterMatch(stack, other);
        }
        return null;
    }

    @Override
    @Nullable
    public List<Component> getCustomTooltip(ItemStack stack) {
        if (FTBFilterSystemAPI.api().isFilterItem(stack)) {
            try {
                List dump = FTBFilterSystemAPI.api().dump(FTBFilterSystemAPI.api().parseFilter(stack));
                ArrayList<Component> tooltip = new ArrayList<Component>();
                for (DumpedFilter filter : dump) {
                    Component arg;
                    MutableComponent line = FTBFilter.indent(filter);
                    SmartFilter f = filter.filter();
                    line.m_7220_(f.getDisplayName());
                    if (!(f instanceof SmartFilter.Compound) && !(arg = f.getDisplayArg()).getString().isEmpty()) {
                        line.m_130946_(" ").m_7220_((Component)arg.m_6881_().m_130940_(ChatFormatting.BLUE));
                    }
                    tooltip.add((Component)line);
                }
                return tooltip;
            }
            catch (FilterException filterException) {
                // empty catch block
            }
        }
        return null;
    }

    private static MutableComponent indent(DumpedFilter filter) {
        MutableComponent line = EasyText.empty();
        if (filter.indent() > 0) {
            StringBuilder b = new StringBuilder(" ");
            while (b.length() < filter.indent()) {
                b.append(" ");
            }
            line.m_130946_(b.toString());
        }
        return line;
    }
}

