/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.cap;

import io.github.lightman314.lightmanscurrency.api.capability.variant.CapabilityVariantData;
import io.github.lightman314.lightmanscurrency.api.variants.block.builtin.VariantDataStorageAttachment;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SPacketSyncVariantBECap
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketSyncVariantBECap> HANDLER = new H();
    private final BlockPos pos;
    @Nullable
    private final ResourceLocation variantID;
    private final boolean locked;

    public SPacketSyncVariantBECap(BlockPos pos, @Nullable ResourceLocation variantID, boolean locked) {
        this.pos = pos;
        this.variantID = variantID;
        this.locked = locked;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.variantID != null);
        if (this.variantID != null) {
            buffer.m_130085_(this.variantID);
        }
        buffer.writeBoolean(this.locked);
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncVariantBECap> {
        private H() {
        }

        @Override
        public SPacketSyncVariantBECap decode(FriendlyByteBuf buffer) {
            BlockPos pos = buffer.m_130135_();
            ResourceLocation variantID = null;
            if (buffer.readBoolean()) {
                variantID = buffer.m_130281_();
            }
            return new SPacketSyncVariantBECap(pos, variantID, buffer.readBoolean());
        }

        @Override
        protected void handle(SPacketSyncVariantBECap message, Player player) {
            BlockEntity be;
            if (player != null && (be = player.m_9236_().m_7702_(message.pos)) != null) {
                be.getCapability(CapabilityVariantData.CAPABILITY).ifPresent(data -> {
                    if (data instanceof VariantDataStorageAttachment) {
                        VariantDataStorageAttachment d = (VariantDataStorageAttachment)data;
                        data.setVariant(message.variantID, message.locked);
                    }
                });
            }
        }
    }
}

