/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.player;

import io.github.lightman314.lightmanscurrency.client.data.ClientPlayerNameCache;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SPacketUpdatePlayerCache
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketUpdatePlayerCache> HANDLER = new H();
    private final UUID playerID;
    private final String playerName;

    public SPacketUpdatePlayerCache(UUID playerID, String playerName) {
        this.playerID = playerID;
        this.playerName = playerName;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.playerID);
        buffer.m_130070_(this.playerName);
    }

    private static class H
    extends CustomPacket.Handler<SPacketUpdatePlayerCache> {
        private H() {
        }

        @Override
        public SPacketUpdatePlayerCache decode(FriendlyByteBuf buffer) {
            return new SPacketUpdatePlayerCache(buffer.m_130259_(), buffer.m_130277_());
        }

        @Override
        protected void handle(SPacketUpdatePlayerCache message, Player player) {
            ClientPlayerNameCache.addCacheEntry(message.playerID, message.playerName);
        }
    }
}

