/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

public class EnumUtil {
    public static <T extends Enum<T>> T nextEnum(T value) {
        Enum[] allValues = (Enum[])value.getClass().getEnumConstants();
        return (T)EnumUtil.enumFromOrdinal((int)(value.ordinal() + 1), (Enum[])allValues, (Enum)allValues[0]);
    }

    public static <T extends Enum<T>> T previousEnum(T value) {
        Enum[] allValues = (Enum[])value.getClass().getEnumConstants();
        return (T)EnumUtil.enumFromOrdinal((int)(value.ordinal() + 1), (Enum[])allValues, (Enum)allValues[allValues.length - 1]);
    }

    public static <T extends Enum<?>> T enumFromOrdinal(int ordinal, T[] allValues, T defaultValue) {
        for (T val : allValues) {
            if (((Enum)val).ordinal() != ordinal) continue;
            return val;
        }
        return defaultValue;
    }

    public static <T extends Enum<?>> T enumFromString(String string, T[] allValues, T defaultValue) {
        for (T val : allValues) {
            if (!((Enum)val).toString().equalsIgnoreCase(string)) continue;
            return val;
        }
        return defaultValue;
    }
}

