/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import dev.obscuria.caravans.PillagerCaravans;
import dev.obscuria.caravans.config.CommonConfig;
import dev.obscuria.caravans.content.IWeighted;
import dev.obscuria.caravans.content.caravan.CaravanPlacement;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public final class CaravanSpawner
implements CustomSpawner {
    public static final CaravanSpawner INSTANCE = new CaravanSpawner();
    public int cooldownTick = 12000;

    public int tick(ServerLevel level, boolean spawnHostile, boolean spawnFriendly) {
        if (!this.shouldSpawn(level, spawnHostile)) {
            return 0;
        }
        ServerPlayer player = this.selectPlayer(level);
        if (player == null) {
            return 0;
        }
        BlockPos.MutableBlockPos pos = this.selectPosition(level, player);
        if (pos == null) {
            return 0;
        }
        Holder<CaravanVariation> caravan = this.selectCaravan(level, (BlockPos)pos);
        if (caravan == null) {
            return 0;
        }
        int totalSpawned = ((CaravanVariation)caravan.value()).spawn(caravan, level, (BlockPos)pos);
        if (totalSpawned <= 0) {
            return 0;
        }
        this.cooldownTick = ((CaravanVariation)caravan.value()).actualCooldown();
        return totalSpawned;
    }

    private boolean shouldSpawn(ServerLevel level, boolean spawnHostile) {
        if (!((Boolean)CommonConfig.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!spawnHostile || !level.getGameRules().getBoolean(PillagerCaravans.RULE_DO_CARAVAN_SPAWNING)) {
            return false;
        }
        if (--this.cooldownTick > 0) {
            return false;
        }
        this.cooldownTick = (Integer)CommonConfig.SPAWN_FAILED_COOLDOWN.get();
        return level.getDayTime() / (long)((Integer)CommonConfig.SPAWN_WORLD_AGE_REQUIRED.get()).intValue() >= 1L;
    }

    @Nullable
    private ServerPlayer selectPlayer(ServerLevel level) {
        int players = level.players().size();
        if (players < 1) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)level.players().get(level.random.nextInt(players));
        if (player.isSpectator()) {
            return null;
        }
        if (level.isCloseToVillage(player.blockPosition(), 2)) {
            return null;
        }
        return player;
    }

    @Nullable
    private BlockPos.MutableBlockPos selectPosition(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.random;
        Integer distance = (Integer)CommonConfig.SPAWN_DISTANCE.get();
        Integer variance = (Integer)CommonConfig.SPAWN_DISTANCE_VARIANCE.get();
        int xOffset = (distance + random.nextInt(variance.intValue())) * (random.nextBoolean() ? -1 : 1);
        int yOffset = (distance + random.nextInt(variance.intValue())) * (random.nextBoolean() ? -1 : 1);
        BlockPos.MutableBlockPos pos = player.blockPosition().mutable().move(xOffset, 0, yOffset);
        if (!level.hasChunksAt(pos.getX() - 10, pos.getZ() - 10, pos.getX() + 10, pos.getZ() + 10)) {
            return null;
        }
        return pos;
    }

    @Nullable
    private Holder<CaravanVariation> selectCaravan(ServerLevel level, BlockPos pos) {
        Registry registry = level.registryAccess().registryOrThrow(CaravanRegistries.Keys.PLACEMENT);
        Holder biome = level.getBiome(pos);
        List<CaravanPlacement> candidates = registry.stream().filter(it -> it.isFor((Holder<Biome>)biome)).toList();
        CaravanPlacement placement = IWeighted.pickRandom(candidates, level.random);
        return placement == null ? null : placement.getRandomVariation(level.random);
    }
}

