/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.client;

import dev.obscuria.fragmentum.content.world.tooltip.GroupTooltip;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public record ClientGroupTooltip(List<ClientTooltipComponent> components) implements ClientTooltipComponent
{
    public static ClientGroupTooltip create(GroupTooltip tooltip) {
        return new ClientGroupTooltip(tooltip.components().stream().map(ClientTooltipComponent::create).toList());
    }

    @Nullable
    public static <T extends ClientTooltipComponent> T findFirst(List<ClientTooltipComponent> components, Class<T> type) {
        for (ClientTooltipComponent component : components) {
            ClientGroupTooltip group;
            T result;
            if (type.isInstance(component)) {
                return (T)component;
            }
            if (!(component instanceof ClientGroupTooltip) || (result = ClientGroupTooltip.findFirst((group = (ClientGroupTooltip)component).components(), type)) == null) continue;
            return result;
        }
        return null;
    }

    public int getHeight() {
        int result = 0;
        for (ClientTooltipComponent component : this.components) {
            result += component.getHeight();
        }
        return result;
    }

    public int getWidth(Font font) {
        int result = 0;
        for (ClientTooltipComponent component : this.components) {
            result += component.getWidth(font);
        }
        return result;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int offset = 0;
        for (ClientTooltipComponent component : this.components) {
            component.renderImage(font, x, y + offset, graphics);
            offset += component.getHeight();
        }
    }

    public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource source) {
        int offset = 0;
        for (ClientTooltipComponent component : this.components) {
            component.renderText(font, mouseX, mouseY + offset, matrix, source);
            offset += component.getHeight();
        }
    }
}

