/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.packs;

import dev.obscuria.fragmentum.Fragmentum;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.jetbrains.annotations.Nullable;

public final class FragmentumLayer {

    public record ResourcesSupplier(Path root) implements Pack.ResourcesSupplier
    {
        public PackResources openPrimary(PackLocationInfo info) {
            return new Resources(info, this.root);
        }

        public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
            return new Resources(info, this.root);
        }
    }

    public static final class Resources
    extends PathPackResources {
        public Resources(PackLocationInfo info, Path root) {
            super(info, root);
        }

        @Nullable
        public IoSupplier<InputStream> getRootResource(String ... path) {
            String fileName = String.join((CharSequence)"/", path);
            if (!fileName.equals("pack.png")) {
                return super.getRootResource(path);
            }
            return this::getDefaultIcon;
        }

        private InputStream getDefaultIcon() {
            try {
                InputStream resource = Fragmentum.class.getResourceAsStream("/fragmentum.png");
                if (resource == null) {
                    throw new IllegalStateException("Resource `fragmentum.png` not found");
                }
                return resource;
            }
            catch (Exception exception) {
                Fragmentum.LOGGER.error("Failed to load Fragmentum icon", (Throwable)exception);
                return InputStream.nullInputStream();
            }
        }
    }

    public record Source(Path directory, PackType type) implements RepositorySource
    {
        public static final PackLocationInfo INFO;
        public static final Pack.Metadata CLIENT_METADATA;
        public static final Pack.Metadata SERVER_METADATA;
        public static final PackSelectionConfig CONFIG;

        public static Source create(PackType type) {
            Path userDir = Path.of(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
            return new Source(userDir.resolve("config/fragmentum"), type);
        }

        public void loadPacks(Consumer<Pack> consumer) {
            Pack.Metadata metadata = this.type == PackType.CLIENT_RESOURCES ? CLIENT_METADATA : SERVER_METADATA;
            ResourcesSupplier resourceSupplier = new ResourcesSupplier(this.directory);
            consumer.accept(new Pack(INFO, (Pack.ResourcesSupplier)resourceSupplier, metadata, CONFIG));
        }

        static {
            CONFIG = new PackSelectionConfig(true, Pack.Position.TOP, false);
            INFO = new PackLocationInfo("generated/fragmentum_layer", (Component)Component.literal((String)"Fragmentum Layer"), PackSource.BUILT_IN, Optional.empty());
            CLIENT_METADATA = new Pack.Metadata((Component)Component.literal((String)"Global resources"), PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of());
            SERVER_METADATA = new Pack.Metadata((Component)Component.literal((String)"Global configurations"), PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of());
        }
    }
}

