/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.registry;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.obscuria.fragmentum.content.registry.LazyHolder;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface RegistryLazyCodec<E>
extends Codec<LazyHolder<E>> {
    public static <E> RegistryLazyCodec<E> create(ResourceKey<? extends Registry<E>> registryKey, Supplier<RegistryAccess> registryAccess) {
        return new Instance(registryKey, registryAccess);
    }

    public record Instance<E>(ResourceKey<? extends Registry<E>> registryKey, Supplier<RegistryAccess> registryAccess) implements RegistryLazyCodec<E>
    {
        public <T> DataResult<T> encode(LazyHolder<E> holder, DynamicOps<T> ops, T value) {
            return (DataResult)holder.getOrThrow().unwrap().map(key -> ResourceLocation.CODEC.encode((Object)key.location(), ops, value), element -> DataResult.error(() -> "Elements from registry %s can't be serialized to a value".formatted(this.registryKey)));
        }

        public <T> DataResult<Pair<LazyHolder<E>, T>> decode(DynamicOps<T> ops, T value) {
            return ResourceLocation.CODEC.decode(ops, value).flatMap(pair -> DataResult.success((Object)Pair.of(LazyHolder.create(this.registryKey, this.registryAccess, (ResourceLocation)pair.getFirst()), (Object)pair.getSecond())));
        }

        @Override
        public String toString() {
            return "RegistryLazyCodec[" + String.valueOf(this.registryKey) + "]";
        }
    }
}

