/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.script.types;

import dev.obscuria.fragmentum.content.script.types.LuaOps;
import dev.obscuria.fragmentum.content.script.types.LuaWrapper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaValue;

public class LuaItemStack
extends LuaWrapper<ItemStack> {
    public static final LuaOps<ItemStack> OPS = LuaOps.nonnil(LuaItemStack::valueOf, LuaItemStack::nonnilSourceOf);
    public static final LuaOps.Nilable<ItemStack> NIL_OPS = LuaOps.nilable(LuaItemStack::valueOf, LuaItemStack::nilableSourceOf);

    public LuaItemStack(ItemStack stack) {
        super(stack, OPS);
    }

    @Override
    protected void build(LuaWrapper.Builder builder) {
        builder.put("count", LuaWrapper.Property.of(LuaOps.INT, ItemStack::getCount, ItemStack::setCount));
        builder.put("damageValue", LuaWrapper.Property.of(LuaOps.INT, ItemStack::getDamageValue, ItemStack::setDamageValue));
        builder.put("isEmpty", this.method0(LuaOps.BOOL, ItemStack::isEmpty));
        builder.put("isStackable", this.method0(LuaOps.BOOL, ItemStack::isStackable));
        builder.put("isDamaged", this.method0(LuaOps.BOOL, ItemStack::isDamaged));
        builder.put("isDamageable", this.method0(LuaOps.BOOL, ItemStack::isDamageableItem));
        builder.put("getMaxStackSize", this.method0(LuaOps.INT, ItemStack::getMaxStackSize));
        builder.put("getMaxDamage", this.method0(LuaOps.INT, ItemStack::getMaxDamage));
        builder.put("grow", this.voidMethod1(LuaOps.INT, ItemStack::grow));
        builder.put("shrink", this.voidMethod1(LuaOps.INT, ItemStack::shrink));
        builder.put("split", this.method1(LuaOps.INT, OPS, ItemStack::split));
        builder.put("copyWithCount", this.method1(LuaOps.INT, OPS, ItemStack::copyWithCount));
    }

    private static LuaValue valueOf(@Nullable ItemStack source) {
        return source == null ? LuaValue.NIL : new LuaItemStack(source);
    }

    @Nullable
    private static ItemStack nilableSourceOf(LuaValue value) {
        return value.isnil() ? null : (ItemStack)((LuaItemStack)value).getSource();
    }

    private static ItemStack nonnilSourceOf(LuaValue value) {
        return (ItemStack)((LuaItemStack)value).getSource();
    }
}

