/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.world.tooltip;

import dev.obscuria.fragmentum.content.util.color.RGB;
import dev.obscuria.fragmentum.content.world.tooltip.StyleFlag;
import dev.obscuria.fragmentum.content.world.tooltip.TooltipOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TooltipBuilder {
    private final TooltipOptions options;
    private final List<Component> lines = new ArrayList<Component>();
    private final List<RGB> colors = new ArrayList<RGB>();
    private final EnumSet<StyleFlag> flags = EnumSet.noneOf(StyleFlag.class);
    private MutableComponent line = Component.empty();
    private int lineLength = 0;
    private boolean isLineEmpty = true;

    public TooltipBuilder(TooltipOptions options) {
        this.options = options;
    }

    public void pushColor(RGB color) {
        this.colors.add(color);
    }

    public void popColor() {
        if (!this.colors.isEmpty()) {
            this.colors.remove(this.colors.size() - 1);
        }
    }

    public void pushFlag(StyleFlag flag) {
        this.flags.add(flag);
    }

    public void popFlag(StyleFlag flag) {
        this.flags.remove((Object)flag);
    }

    public void breakLine() {
        this.flush();
    }

    public void prepareForAppend(int length) {
        if (this.lineLength + length + 1 > this.options.maxLineLength()) {
            this.flush();
        }
    }

    public void maybeAppendSpacing() {
        if (!this.isLineEmpty) {
            this.line.append(CommonComponents.SPACE);
            ++this.lineLength;
        }
    }

    public void append(int length, MutableComponent component) {
        this.line.append((Component)this.applyStyle(component));
        this.lineLength += length;
        this.isLineEmpty = false;
    }

    public List<Component> result() {
        if (!this.isLineEmpty) {
            this.flush();
        }
        return Collections.unmodifiableList(this.lines);
    }

    private MutableComponent applyStyle(MutableComponent component) {
        for (RGB color : this.colors) {
            component.withStyle(component.getStyle().withColor(color.decimal()));
        }
        if (this.flags.contains((Object)StyleFlag.ITALIC)) {
            component.withStyle(component.getStyle().withItalic(Boolean.valueOf(true)));
        }
        if (this.flags.contains((Object)StyleFlag.NON_ITALIC)) {
            component.withStyle(component.getStyle().withItalic(Boolean.valueOf(false)));
        }
        if (this.flags.contains((Object)StyleFlag.BOLD)) {
            component.withStyle(component.getStyle().withBold(Boolean.valueOf(true)));
        }
        if (this.flags.contains((Object)StyleFlag.NON_BOLD)) {
            component.withStyle(component.getStyle().withBold(Boolean.valueOf(false)));
        }
        return component;
    }

    private void flush() {
        this.lines.add((Component)this.line.withStyle(this.options.getLineStyle(this.lines.size())));
        this.line = Component.empty();
        this.isLineEmpty = true;
        this.lineLength = 0;
    }
}

