/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.world.tooltip;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public record TooltipOptions(ImmutableMap<Integer, String> prefixByLine, ImmutableMap<Integer, Style> styleByLine, Function<String, MutableComponent> processor, String defaultPrefix, Style defaultStyle, int maxLineLength) {
    public static final TooltipOptions DEFAULT = TooltipOptions.builder().build();
    public static final TooltipOptions DESCRIPTION = TooltipOptions.builder().withDefaultStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)).build();
    public static final TooltipOptions LORE = TooltipOptions.builder().withDefaultStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE)).build();
    public static final TooltipOptions ERROR = TooltipOptions.builder().withDefaultStyle(Style.EMPTY.withColor(ChatFormatting.RED)).build();

    public static Builder builder() {
        return new Builder();
    }

    public String getLinePrefix(int index) {
        return Objects.requireNonNull((String)this.prefixByLine.getOrDefault((Object)index, (Object)this.defaultPrefix));
    }

    public Style getLineStyle(int index) {
        return Objects.requireNonNull((Style)this.styleByLine.getOrDefault((Object)index, (Object)this.defaultStyle));
    }

    public static class Builder {
        private final ImmutableMap.Builder<Integer, String> prefixByLine = new ImmutableMap.Builder();
        private final ImmutableMap.Builder<Integer, Style> styleByLine = new ImmutableMap.Builder();
        private Function<String, MutableComponent> processor = Component::literal;
        private String defaultPrefix = "";
        private Style defaultStyle = Style.EMPTY;
        private int maxLineLength = 40;

        private Builder() {
        }

        public Builder withLineSpecificPrefix(int line, String prefix) {
            this.prefixByLine.put((Object)line, (Object)prefix);
            return this;
        }

        public Builder withLineSpecificStyle(int line, Style style) {
            this.styleByLine.put((Object)line, (Object)style);
            return this;
        }

        public Builder withProcessor(Function<String, MutableComponent> processor) {
            this.processor = processor;
            return this;
        }

        public Builder withDefaultPrefix(String prefix) {
            this.defaultPrefix = prefix;
            return this;
        }

        public Builder withDefaultStyle(Style style) {
            this.defaultStyle = style;
            return this;
        }

        public Builder withMaxLineLength(int maxLineLength) {
            this.maxLineLength = maxLineLength;
            return this;
        }

        public TooltipOptions build() {
            return new TooltipOptions((ImmutableMap<Integer, String>)this.prefixByLine.build(), (ImmutableMap<Integer, Style>)this.styleByLine.build(), this.processor, this.defaultPrefix, this.defaultStyle, this.maxLineLength);
        }
    }
}

