/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.neoforge.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.obscuria.fragmentum.content.registry.DelegatedRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class NeoDelegatedRegistry<T>
implements DelegatedRegistry<T> {
    private final ResourceKey<? extends Registry<T>> key;
    private final Codec<Holder<T>> holderByNameCodec = this.createHolderByNameCodec();
    private final Registry<T> source;

    public NeoDelegatedRegistry(Registry<T> registry) {
        this.source = registry;
        this.key = registry.key();
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    @Override
    public ResourceLocation name() {
        return this.key().registry();
    }

    @Override
    public Codec<T> byNameCodec() {
        return this.source.byNameCodec();
    }

    @Override
    public Codec<Holder<T>> holderByNameCodec() {
        return this.holderByNameCodec;
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return this.source.keySet();
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return this.source.entrySet();
    }

    @Override
    public boolean containsKey(ResourceLocation id) {
        return this.source.containsKey(id);
    }

    @Override
    public T get(ResourceLocation id) {
        return (T)this.source.get(id);
    }

    @Override
    public Holder.Reference<T> getHolder(ResourceLocation id) {
        return this.source.getHolder(id).orElse(null);
    }

    @Override
    public ResourceLocation getKey(T value) {
        return this.source.getKey(value);
    }

    @Override
    public ResourceLocation getKey(Holder<T> holder) {
        return holder.unwrap().right().map(this::getKey).orElse(null);
    }

    private Codec<Holder<T>> createHolderByNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(reference -> reference, this::safeCastToReference);
    }

    private Codec<Holder.Reference<T>> referenceHolderWithLifecycle() {
        return ResourceLocation.CODEC.comapFlatMap(id -> Optional.ofNullable(this.getHolder((ResourceLocation)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.key()) + ": " + String.valueOf(id))), reference -> reference.key().location());
    }

    private DataResult<Holder.Reference<T>> safeCastToReference(Holder<T> value) {
        DataResult dataResult;
        if (value instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)value;
            dataResult = DataResult.success((Object)reference);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(this.key()) + ": " + String.valueOf(value));
        }
        return dataResult;
    }
}

