/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

public final class TooltipComponentRegistry {
    private static final List<Definition<?>> definitions = new ArrayList();

    public static <T extends class_5632> void register(Class<T> type, Function<T, class_5684> factory) {
        if (definitions.stream().anyMatch(it -> it.type.equals(type))) {
            return;
        }
        definitions.add(new Definition<T>(type, factory));
    }

    public static Optional<class_5684> create(class_5632 component) {
        for (Definition<?> definition : definitions) {
            if (!definition.isFor(component)) continue;
            return Optional.of(definition.create(component));
        }
        return Optional.empty();
    }

    private record Definition<T extends class_5632>(Class<T> type, Function<T, class_5684> factory) {
        public boolean isFor(class_5632 component) {
            return component.getClass().equals(this.type);
        }

        public class_5684 create(class_5632 component) {
            return this.factory.apply((class_5632)this.type.cast(component));
        }
    }
}

