/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.world.tooltip;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public record TooltipOptions(ImmutableMap<Integer, String> prefixByLine, ImmutableMap<Integer, class_2583> styleByLine, Function<String, class_5250> processor, String defaultPrefix, class_2583 defaultStyle, int maxLineLength) {
    public static final TooltipOptions DEFAULT = TooltipOptions.builder().build();
    public static final TooltipOptions DESCRIPTION = TooltipOptions.builder().withDefaultStyle(class_2583.field_24360.method_10977(class_124.field_1080)).build();
    public static final TooltipOptions LORE = TooltipOptions.builder().withDefaultStyle(class_2583.field_24360.method_10977(class_124.field_1076)).build();
    public static final TooltipOptions ERROR = TooltipOptions.builder().withDefaultStyle(class_2583.field_24360.method_10977(class_124.field_1061)).build();

    public static Builder builder() {
        return new Builder();
    }

    public String getLinePrefix(int index) {
        return Objects.requireNonNull((String)this.prefixByLine.getOrDefault((Object)index, (Object)this.defaultPrefix));
    }

    public class_2583 getLineStyle(int index) {
        return Objects.requireNonNull((class_2583)this.styleByLine.getOrDefault((Object)index, (Object)this.defaultStyle));
    }

    public static class Builder {
        private final ImmutableMap.Builder<Integer, String> prefixByLine = new ImmutableMap.Builder();
        private final ImmutableMap.Builder<Integer, class_2583> styleByLine = new ImmutableMap.Builder();
        private Function<String, class_5250> processor = class_2561::method_43470;
        private String defaultPrefix = "";
        private class_2583 defaultStyle = class_2583.field_24360;
        private int maxLineLength = 40;

        private Builder() {
        }

        public Builder withLineSpecificPrefix(int line, String prefix) {
            this.prefixByLine.put((Object)line, (Object)prefix);
            return this;
        }

        public Builder withLineSpecificStyle(int line, class_2583 style) {
            this.styleByLine.put((Object)line, (Object)style);
            return this;
        }

        public Builder withProcessor(Function<String, class_5250> processor) {
            this.processor = processor;
            return this;
        }

        public Builder withDefaultPrefix(String prefix) {
            this.defaultPrefix = prefix;
            return this;
        }

        public Builder withDefaultStyle(class_2583 style) {
            this.defaultStyle = style;
            return this;
        }

        public Builder withMaxLineLength(int maxLineLength) {
            this.maxLineLength = maxLineLength;
            return this;
        }

        public TooltipOptions build() {
            return new TooltipOptions((ImmutableMap<Integer, String>)this.prefixByLine.build(), (ImmutableMap<Integer, class_2583>)this.styleByLine.build(), this.processor, this.defaultPrefix, this.defaultStyle, this.maxLineLength);
        }
    }
}

