/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.fabric.service;

import dev.obscuria.fragmentum.content.network.PayloadRegistrar;
import dev.obscuria.fragmentum.fabric.registry.FabricNetworking;
import dev.obscuria.fragmentum.fabric.registry.FabricPayloadRegistrar;
import dev.obscuria.fragmentum.service.NetworkService;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public final class FabricNetworkService
implements NetworkService {
    public static final FabricNetworkService INSTANCE = new FabricNetworkService();

    private FabricNetworkService() {
    }

    @Override
    public PayloadRegistrar payloadRegistrar(String modId) {
        return new FabricPayloadRegistrar(modId);
    }

    @Override
    public <T extends class_8710> void reply(T payload) {
        if (FabricNetworking.clientReplySender != null) {
            FabricNetworking.clientReplySender.sendPacket(payload);
        }
        if (FabricNetworking.serverReplySender != null) {
            FabricNetworking.serverReplySender.sendPacket(payload);
        }
    }

    @Override
    public <T extends class_8710> void sendTo(class_3222 player, T payload) {
        ServerPlayNetworking.send((class_3222)player, payload);
    }

    @Override
    public <T extends class_8710> void sendToAllTracking(class_3218 level, class_2338 pos, T payload) {
        PlayerLookup.tracking((class_3218)level, (class_2338)pos).forEach(player -> this.sendTo((class_3222)player, payload));
    }

    @Override
    public <T extends class_8710> void sendToAllTracking(class_1297 entity, T payload) {
        PlayerLookup.tracking((class_1297)entity).forEach(player -> this.sendTo((class_3222)player, payload));
    }

    @Override
    public <T extends class_8710> void sendToAll(MinecraftServer server, T payload) {
        PlayerLookup.all((MinecraftServer)server).forEach(player -> this.sendTo((class_3222)player, payload));
    }

    @Override
    public <T extends class_8710> void sendToServer(T payload) {
        ClientPlayNetworking.send(payload);
    }
}

