/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.obscuria.caravans.content.caravan.CaravanSpawner;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import dev.obscuria.caravans.mixin.ResourceKeyArgumentAccessor;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7079;
import net.minecraft.class_7157;

public final class CaravanCommand {
    private static final DynamicCommandExceptionType ERR_INVALID_VARIATION = new DynamicCommandExceptionType(it -> class_2561.method_43469((String)"commands.caravan.spawn.invalid", (Object[])new Object[]{it}));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"caravan").requires(it -> it.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cooldown").then(class_2170.method_9247((String)"get").executes(it -> CaravanCommand.getCooldown((class_2168)it.getSource())))).then(class_2170.method_9247((String)"reset").executes(it -> CaravanCommand.resetCooldown((class_2168)it.getSource())))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(it -> CaravanCommand.setCooldown((class_2168)it.getSource(), IntegerArgumentType.getInteger((CommandContext)it, (String)"ticks"))))))).then(class_2170.method_9247((String)"spawn").then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"variation", (ArgumentType)class_7079.method_41224(CaravanRegistries.Keys.VARIATION)).executes(it -> CaravanCommand.spawn((class_2168)it.getSource(), class_2262.method_48299((CommandContext)it, (String)"position"), CaravanCommand.getCaravansVariation((CommandContext<class_2168>)it, "variation")))))));
    }

    public static int getCooldown(class_2168 source) {
        int ticks = CaravanSpawner.INSTANCE.cooldownTick;
        source.method_9226(() -> class_2561.method_43469((String)"commands.caravan.cooldown.get", (Object[])new Object[]{ticks}), false);
        return ticks;
    }

    public static int resetCooldown(class_2168 source) {
        CaravanSpawner.INSTANCE.cooldownTick = 0;
        source.method_9226(() -> class_2561.method_43471((String)"commands.caravan.cooldown.reset"), true);
        return 1;
    }

    public static int setCooldown(class_2168 source, int ticks) {
        CaravanSpawner.INSTANCE.cooldownTick = ticks;
        source.method_9226(() -> class_2561.method_43469((String)"commands.caravan.cooldown.set", (Object[])new Object[]{ticks}), true);
        return 1;
    }

    private static int spawn(class_2168 source, class_2338 pos, class_6880.class_6883<CaravanVariation> variation) {
        class_2960 id = variation.method_40237().method_29177();
        source.method_9226(() -> class_2561.method_43469((String)"commands.caravan.spawn.success", (Object[])new Object[]{id.toString(), pos.method_10263(), pos.method_10264(), pos.method_10260()}), true);
        return ((CaravanVariation)variation.comp_349()).spawn((class_6880<CaravanVariation>)variation, source.method_9225(), pos);
    }

    private static class_6880.class_6883<CaravanVariation> getCaravansVariation(CommandContext<class_2168> context, String name) {
        return ResourceKeyArgumentAccessor.invokeResolveKey(context, name, CaravanRegistries.Keys.VARIATION, ERR_INVALID_VARIATION);
    }
}

