/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum;

import dev.obscuria.fragmentum.Fragmentum;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ModCompat {
    private final String modId;
    private final String modName;

    public ModCompat(String modId) {
        this(modId, modId);
    }

    public ModCompat(String modId, String modName) {
        this.modId = modId;
        this.modName = modName;
    }

    public String modId() {
        return this.modId;
    }

    public String ModName() {
        return this.modName;
    }

    public boolean isLoaded() {
        return Fragmentum.PLATFORM.isModLoaded(this.modId);
    }

    <T> @Nullable T getIfLoaded(Supplier<Supplier<T>> supplier) {
        if (!this.isLoaded()) {
            return null;
        }
        return supplier.get().get();
    }

    void runIfLoaded(Supplier<Runnable> runnable) {
        if (!this.isLoaded()) {
            return;
        }
        runnable.get().run();
    }

    void runIfMissing(Runnable runnable) {
        if (this.isLoaded()) {
            return;
        }
        runnable.run();
    }
}

