/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.registry;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface LazyHolder<T> {
    public static <T> LazyHolder<T> create(ResourceKey<? extends Registry<T>> registryKey, Supplier<RegistryAccess> registryAccess, ResourceLocation id) {
        return new Instance(registryKey, registryAccess, id);
    }

    @Nullable
    public Holder<T> get();

    public Holder<T> getOrThrow();

    public static class Instance<T>
    implements LazyHolder<T> {
        private final ResourceKey<? extends Registry<T>> registryKey;
        private final Supplier<RegistryAccess> registryAccess;
        private final ResourceLocation id;
        @Nullable
        private Holder<T> holder;

        public Instance(ResourceKey<? extends Registry<T>> registryKey, Supplier<RegistryAccess> registryAccess, ResourceLocation id) {
            this.registryKey = registryKey;
            this.registryAccess = registryAccess;
            this.id = id;
        }

        @Override
        public Holder<T> getOrThrow() {
            if (this.holder != null) {
                return this.holder;
            }
            ResourceKey resourceKey = ResourceKey.m_135785_(this.registryKey, (ResourceLocation)this.id);
            this.holder = this.registryAccess.get().m_175515_(this.registryKey).m_246971_(resourceKey);
            return this.holder;
        }

        @Override
        @Nullable
        public Holder<T> get() {
            try {
                return this.getOrThrow();
            }
            catch (Exception ignored) {
                return null;
            }
        }
    }
}

