/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans;

import dev.obscuria.caravans.ICaravanServices;
import dev.obscuria.caravans.config.CommonConfig;
import dev.obscuria.caravans.content.network.ClientboundEncounterPayload;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import dev.obscuria.caravans.server.CaravanCommand;
import dev.obscuria.fragmentum.network.FragmentumNetworking;
import dev.obscuria.fragmentum.network.PayloadRegistrar;
import dev.obscuria.fragmentum.packs.BuiltInPackBuilder;
import dev.obscuria.fragmentum.server.FragmentumServerRegistry;
import java.util.ServiceLoader;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PillagerCaravans {
    public static final String MODID = "caravans";
    public static final String DISPLAY_NAME = "Pillager Caravans";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Pillager Caravans");
    public static final ICaravanServices SERVICES = ServiceLoader.load(ICaravanServices.class).findFirst().orElseThrow();
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DO_CARAVAN_SPAWNING = SERVICES.registerGameRule("doCaravanSpawning", GameRules.Category.SPAWNING, true);

    public static ResourceLocation key(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static void init() {
        CommonConfig.init();
        CaravanRegistries.init();
        FragmentumServerRegistry.registerCommand(CaravanCommand::register);
        PillagerCaravans.registerPayloads();
        PillagerCaravans.registerBuiltInPacks();
    }

    private static void registerPayloads() {
        PayloadRegistrar registrar = FragmentumNetworking.registrar((String)MODID);
        registrar.registerClientbound(ClientboundEncounterPayload.class, ClientboundEncounterPayload::encode, ClientboundEncounterPayload::decode, ClientboundEncounterPayload::handle);
    }

    private static void registerBuiltInPacks() {
        BuiltInPackBuilder.dataPack((String)"packs/classic_caravans").displayName((Component)Component.m_237113_((String)"Classic Caravans")).packSource(PackSource.f_10528_).register(MODID);
    }
}

