/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.caravans.content.IHorseExtension;
import dev.obscuria.caravans.content.ILivingExtension;
import dev.obscuria.caravans.content.caravan.CaravanVariation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public record CaravanMember(EntityType<?> type, Optional<Item> armorItem, Optional<ResourceLocation> lootTable, Optional<ResourceLocation> cargoTable, int count) {
    public static final Codec<CaravanMember> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)BuiltInRegistries.f_256780_.m_194605_().fieldOf("type").forGetter(CaravanMember::type), (App)BuiltInRegistries.f_257033_.m_194605_().optionalFieldOf("armor").forGetter(CaravanMember::armorItem), (App)ResourceLocation.f_135803_.optionalFieldOf("loot_table").forGetter(CaravanMember::lootTable), (App)ResourceLocation.f_135803_.optionalFieldOf("cargo").forGetter(CaravanMember::cargoTable), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(CaravanMember::count)).apply((Applicative)codec, CaravanMember::new));
    public static boolean generatingCaravanCargo;

    @Nullable
    public Entity spawn(Holder<CaravanVariation> variation, ServerLevel level, BlockPos pos, boolean isLeader) {
        AbstractHorse horse;
        Animal animal;
        AttributeInstance attribute;
        FluidState fluidState;
        BlockState state = level.m_8055_(pos);
        if (!NaturalSpawner.m_47056_((BlockGetter)level, (BlockPos)pos, (BlockState)state, (FluidState)(fluidState = state.m_60819_()), this.type)) {
            return null;
        }
        Entity entity = this.type.m_20615_((Level)level);
        if (entity == null) {
            return null;
        }
        entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ILivingExtension.setCaravanMember(living, true);
        }
        if (isLeader && entity instanceof PatrollingMonster) {
            PatrollingMonster monster = (PatrollingMonster)entity;
            monster.m_33075_(true);
            monster.m_33068_();
            ResourceLocation type = variation.m_203543_().map(ResourceKey::m_135782_).orElse(null);
            ILivingExtension.setCaravanType((LivingEntity)monster, type);
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            DifficultyInstance difficulty = level.m_6436_(pos);
            mob.m_6518_((ServerLevelAccessor)level, difficulty, MobSpawnType.PATROL, null, null);
        }
        if (entity instanceof Animal && (attribute = (animal = (Animal)entity).m_21051_(Attributes.f_22279_)) != null) {
            attribute.m_22125_(this.makeAnimalSpeedModifier());
        }
        if (entity instanceof AbstractHorse) {
            horse = (AbstractHorse)entity;
            horse.m_30651_(true);
            this.armorItem.ifPresent(armor -> IHorseExtension.equipArmor(horse, armor.m_7968_()));
        }
        if (entity instanceof AbstractChestedHorse) {
            horse = (AbstractChestedHorse)entity;
            horse.m_30504_(true);
            IHorseExtension.createInventory(horse);
            this.cargoTable.ifPresent(arg_0 -> this.lambda$spawn$1(level, (AbstractChestedHorse)horse, arg_0));
        }
        level.m_47205_(entity);
        return entity;
    }

    private void generateCargo(ServerLevel level, AbstractChestedHorse entity, ResourceLocation cargo) {
        SimpleContainer inventory = IHorseExtension.getInventory((AbstractHorse)entity);
        LootTable table = level.m_7654_().m_278653_().m_278676_(cargo);
        LootParams params = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287289_(LootContextParams.f_81455_, (Object)entity).m_287235_(LootContextParamSets.f_81411_);
        generatingCaravanCargo = true;
        inventory.m_6836_(0, Items.f_42263_.m_7968_());
        table.m_287188_((Container)IHorseExtension.getInventory((AbstractHorse)entity), params, entity.m_287233_());
        inventory.m_6836_(0, ItemStack.f_41583_);
        generatingCaravanCargo = false;
    }

    private AttributeModifier makeAnimalSpeedModifier() {
        return new AttributeModifier("Caravan modifier", -0.33, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    private /* synthetic */ void lambda$spawn$1(ServerLevel level, AbstractChestedHorse horse, ResourceLocation cargo) {
        this.generateCargo(level, horse, cargo);
    }
}

