/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.content.caravan;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.caravans.config.CommonConfig;
import dev.obscuria.caravans.content.caravan.CaravanMember;
import dev.obscuria.caravans.content.registry.CaravanRegistries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1543;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record CaravanVariation(int cooldown, CaravanMember leader, @Unmodifiable List<CaravanMember> members) {
    public static final Codec<class_6880<CaravanVariation>> CODEC = class_6899.method_40400(CaravanRegistries.Keys.VARIATION);
    public static final Codec<CaravanVariation> DIRECT_CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("cooldown").forGetter(CaravanVariation::cooldown), (App)CaravanMember.CODEC.fieldOf("leader").forGetter(CaravanVariation::leader), (App)CaravanMember.CODEC.listOf().fieldOf("members").forGetter(CaravanVariation::members)).apply((Applicative)codec, CaravanVariation::new));

    public int actualCooldown() {
        return (int)((double)this.cooldown * (Double)CommonConfig.SPAWN_COOLDOWN_MULTIPLIER.get());
    }

    public int spawn(class_6880<CaravanVariation> self, class_3218 level, class_2338 position) {
        class_5819 random = level.field_9229;
        class_2338.class_2339 pos = position.method_25503();
        pos.method_33098(level.method_8598(class_2902.class_2903.field_13203, (class_2338)pos).method_10264());
        if (this.leader.spawn(self, level, (class_2338)pos, true) == null) {
            return 0;
        }
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        for (CaravanMember member : this.members) {
            for (int i = 0; i < member.count(); ++i) {
                pos.method_33097(pos.method_10263() + random.method_43048(3) - random.method_43048(3));
                pos.method_33099(pos.method_10260() + random.method_43048(3) - random.method_43048(3));
                pos.method_33098(level.method_8598(class_2902.class_2903.field_13203, (class_2338)pos).method_10264());
                class_1297 entity = member.spawn(self, level, (class_2338)pos, false);
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        this.leashAnimals(entities, random);
        return 1 + entities.size();
    }

    private void leashAnimals(List<class_1297> entities, class_5819 random) {
        @Nullable class_1429 lastAnimal = null;
        ArrayList holders = entities.stream().filter(this::isValidLeashHolder).collect(Collectors.toCollection(ArrayList::new));
        for (class_1297 member : entities) {
            if (!(member instanceof class_1429)) continue;
            class_1429 animal = (class_1429)member;
            if (lastAnimal != null && random.method_43048(4) < 3) {
                animal.method_5954(lastAnimal, true);
            } else {
                class_1297 holder;
                Collections.shuffle(holders);
                class_1297 class_12972 = holder = holders.isEmpty() ? null : (class_1297)holders.get(0);
                if (holder != null) {
                    animal.method_5954(holder, true);
                }
            }
            lastAnimal = animal;
        }
    }

    private boolean isValidLeashHolder(class_1297 entity) {
        return entity instanceof class_1543;
    }
}

