/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.fabric.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class FabricNetworking {
    public static final Map<Class<?>, Registration<?>> clientboundRegistrations = Maps.newConcurrentMap();
    public static final Map<Class<?>, Registration<?>> serverboundRegistrations = Maps.newConcurrentMap();
    @Nullable
    public static PacketSender clientReplySender;
    @Nullable
    public static PacketSender serverReplySender;

    public static <T> PacketType<Wrapper<T>> registerClientbound(String modId, Class<T> clazz, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder) {
        class_2960 id = new class_2960(modId, "clientbound_" + clazz.getSimpleName().toLowerCase());
        PacketType type = PacketType.create((class_2960)id, it -> Wrapper.clientbound(clazz, decoder.apply((class_2540)it)));
        clientboundRegistrations.put(clazz, new Registration<T>(type, encoder));
        return type;
    }

    public static <T> PacketType<Wrapper<T>> registerServerbound(String modId, Class<T> clazz, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder) {
        class_2960 id = new class_2960(modId, "serverbound_" + clazz.getSimpleName().toLowerCase());
        PacketType type = PacketType.create((class_2960)id, it -> Wrapper.serverbound(clazz, decoder.apply((class_2540)it)));
        serverboundRegistrations.put(clazz, new Registration<T>(type, encoder));
        return type;
    }

    public static FabricPacket clientbound(Object payload) {
        Objects.requireNonNull(clientboundRegistrations.get(payload.getClass()));
        return Wrapper.clientbound(payload.getClass(), payload);
    }

    public static FabricPacket serverbound(Object payload) {
        Objects.requireNonNull(serverboundRegistrations.get(payload.getClass()));
        return Wrapper.serverbound(payload.getClass(), payload);
    }

    public record Registration<T>(PacketType<Wrapper<T>> packetType, BiConsumer<T, class_2540> encoder) {
        public void encode(class_2540 buf, Object payload) {
            this.encoder.accept(payload, buf);
        }
    }

    public record Wrapper<T>(Map<Class<?>, Registration<?>> source, Class<?> type, T payload) implements FabricPacket
    {
        public static <T> Wrapper<T> clientbound(Class<?> type, T payload) {
            return new Wrapper<T>(clientboundRegistrations, type, payload);
        }

        public static <T> Wrapper<T> serverbound(Class<?> type, T payload) {
            return new Wrapper<T>(serverboundRegistrations, type, payload);
        }

        public void write(class_2540 buf) {
            this.source.get(this.type).encode(buf, this.payload);
        }

        public PacketType<?> getType() {
            return this.source.get(this.type).packetType;
        }
    }
}

