/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.world.tooltip;

import dev.obscuria.fragmentum.world.tooltip.TooltipBuilder;
import dev.obscuria.fragmentum.world.tooltip.TooltipOptions;
import dev.obscuria.fragmentum.world.tooltip.TooltipTags;
import dev.obscuria.fragmentum.world.tooltip.TooltipTemplates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class Tooltips {
    private static final char SPACING = ' ';
    private static final String DELIMITER = ", ";
    private static final String CLOSING_MARKER = "/";
    private static final Pattern TAG_PATTERN = Pattern.compile("\\[(/?)([\\w-]+)(?:=([^]\\[]+))?]");
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("<([\\w-]+)=([^>]*)>");

    public static List<class_2561> process(class_2561 input) {
        return Tooltips.process(input.getString(), null, TooltipOptions.DEFAULT);
    }

    public static List<class_2561> process(class_2561 input, Object source) {
        return Tooltips.process(input.getString(), source, TooltipOptions.DEFAULT);
    }

    public static List<class_2561> process(class_2561 input, Object source, TooltipOptions options) {
        return Tooltips.process(input.getString(), source, options);
    }

    public static List<class_2561> process(String input, @Nullable Object source, TooltipOptions options) {
        TooltipBuilder builder = new TooltipBuilder(options);
        List<Node> nodes = Tooltips.parseNodes(input, source);
        for (Node node : nodes) {
            node.process(builder, options);
        }
        return builder.result();
    }

    private static List<Node> parseNodes(String input, @Nullable Object source) {
        ArrayList<Node> group = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>();
        Matcher tagMatcher = TAG_PATTERN.matcher(input);
        while (tagMatcher.find()) {
            matches.add(new MatchResult(tagMatcher.start(), tagMatcher.end(), tagMatcher));
        }
        Matcher templateMatcher = TEMPLATE_PATTERN.matcher(input);
        while (templateMatcher.find()) {
            matches.add(new MatchResult(templateMatcher.start(), templateMatcher.end(), templateMatcher));
        }
        matches.sort(Comparator.comparingInt(a -> a.start));
        int lastIndex = 0;
        for (MatchResult match : matches) {
            String before = input.substring(lastIndex, match.start);
            if (!before.isEmpty()) {
                boolean shouldGroupFirst = !nodes.isEmpty() && !before.startsWith(String.valueOf(' '));
                boolean shouldGroupLast = !before.endsWith(String.valueOf(' '));
                String[] elements = before.split(String.valueOf(' '));
                for (int i = 0; i < elements.length; ++i) {
                    String element = elements[i];
                    if (element.isEmpty()) continue;
                    if (shouldGroupFirst && i == 0) {
                        group.add(new Node.Text(element));
                        continue;
                    }
                    if (shouldGroupLast && i == elements.length - 1) {
                        if (element.length() > 1) {
                            Tooltips.flushGroup(group, nodes);
                        }
                        group.add(new Node.Text(element));
                        continue;
                    }
                    Tooltips.flushGroup(group, nodes);
                    nodes.add(new Node.Text(element));
                }
            }
            if (match.matcher.group().startsWith("[")) {
                key = match.matcher.group(2);
                if (!CLOSING_MARKER.equals(match.matcher.group(1))) {
                    String[] rawArgs = match.matcher.group(3) != null ? match.matcher.group(3).split(DELIMITER) : new String[]{};
                    args = new ArrayList();
                    String[] stringArray = rawArgs;
                    int n = stringArray.length;
                    for (var16_26 = 0; var16_26 < n; ++var16_26) {
                        arg = stringArray[var16_26];
                        if (arg.isEmpty()) continue;
                        args.add(arg);
                    }
                    group.add(new Node.OpeningTag(key, args));
                } else {
                    group.add(new Node.ClosingTag(key));
                }
            } else {
                key = match.matcher.group(1);
                String[] rawArgs = match.matcher.group(2).split(DELIMITER);
                args = new ArrayList<String>();
                String[] stringArray = rawArgs;
                int n = stringArray.length;
                for (var16_26 = 0; var16_26 < n; ++var16_26) {
                    arg = stringArray[var16_26];
                    if (arg.isEmpty()) continue;
                    args.add(arg);
                }
                group.add(new Node.Template(source, key, args));
            }
            lastIndex = match.end;
        }
        String remaining = input.substring(lastIndex);
        if (!remaining.isEmpty()) {
            boolean shouldGroupFirst = !remaining.startsWith(String.valueOf(' '));
            String[] elements = remaining.split(String.valueOf(' '));
            for (int i = 0; i < elements.length; ++i) {
                String element = elements[i];
                if (element.isEmpty()) continue;
                if (shouldGroupFirst && i == 0) {
                    group.add(new Node.Text(element));
                    continue;
                }
                Tooltips.flushGroup(group, nodes);
                nodes.add(new Node.Text(element));
            }
        }
        Tooltips.flushGroup(group, nodes);
        return nodes;
    }

    private static void flushGroup(List<Node> group, List<Node> nodes) {
        if (group.isEmpty()) {
            return;
        }
        if (group.size() == 1) {
            nodes.add(group.remove(0));
        } else {
            nodes.add(new Node.Group(new ArrayList<Node>(group)));
            group.clear();
        }
    }

    private static abstract class Node {
        private Node() {
        }

        abstract int length();

        abstract void process(TooltipBuilder var1, TooltipOptions var2, boolean var3);

        void process(TooltipBuilder builder, TooltipOptions options) {
            this.process(builder, options, false);
        }

        public static class Group
        extends Node {
            private final List<Node> nodes;

            public Group(List<Node> nodes) {
                this.nodes = nodes;
            }

            @Override
            int length() {
                return this.nodes.stream().mapToInt(Node::length).sum();
            }

            @Override
            void process(TooltipBuilder builder, TooltipOptions options, boolean grouped) {
                if (this.length() > 0) {
                    builder.prepareForAppend(this.length());
                    builder.maybeAppendSpacing();
                }
                for (Node node : this.nodes) {
                    node.process(builder, options, true);
                }
            }
        }

        public static class ClosingTag
        extends Node {
            private final String key;

            public ClosingTag(String key) {
                this.key = key;
            }

            @Override
            int length() {
                return 0;
            }

            @Override
            void process(TooltipBuilder builder, TooltipOptions options, boolean grouped) {
                TooltipTags.close(builder, this.key);
            }
        }

        public static class OpeningTag
        extends Node {
            private final String key;
            private final List<String> args;

            public OpeningTag(String key, List<String> args) {
                this.key = key;
                this.args = args;
            }

            @Override
            int length() {
                return 0;
            }

            @Override
            void process(TooltipBuilder builder, TooltipOptions options, boolean grouped) {
                TooltipTags.open(builder, this.key, this.args);
            }
        }

        public static class Template
        extends Node {
            @Nullable
            private final Object source;
            private final String key;
            private final List<String> args;
            private String text;

            public Template(@Nullable Object source, String key, List<String> args) {
                this.source = source;
                this.key = key;
                this.args = args;
            }

            @Override
            int length() {
                this.ensureText();
                return this.text.length();
            }

            private void ensureText() {
                if (this.text == null) {
                    this.text = TooltipTemplates.process(this.source, this.key, this.args);
                }
            }

            @Override
            void process(TooltipBuilder builder, TooltipOptions options, boolean grouped) {
                this.ensureText();
                if (!grouped) {
                    builder.prepareForAppend(this.length());
                    builder.maybeAppendSpacing();
                }
                builder.append(this.length(), class_2561.method_43470((String)this.text));
            }
        }

        public static class Text
        extends Node {
            private final String content;

            public Text(String content) {
                this.content = content;
            }

            @Override
            int length() {
                return this.content.length();
            }

            @Override
            void process(TooltipBuilder builder, TooltipOptions options, boolean grouped) {
                if (!grouped) {
                    builder.prepareForAppend(this.length());
                    builder.maybeAppendSpacing();
                }
                builder.append(this.length(), options.processor().apply(this.content));
            }
        }
    }

    private static class MatchResult {
        int start;
        int end;
        Matcher matcher;

        MatchResult(int start, int end, Matcher matcher) {
            this.start = start;
            this.end = end;
            this.matcher = matcher;
        }
    }
}

