/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crustychunks.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.mcreator.crustychunks.entity.MuzzleFlashProducerEntity;
import net.mcreator.crustychunks.entity.SmallMuzzleFlashProducerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderProjectileFlashProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.f_82478_;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(double x, double y, double z, int color) {
        RenderProjectileFlashProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(double x, double y, double z, float u, float v, int color) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (format == DefaultVertexFormat.f_85815_) {
            bufferBuilder.m_5483_(x, y, z).m_193479_(color).m_5752_();
        } else if (format == DefaultVertexFormat.f_85819_) {
            bufferBuilder.m_5483_(x, y, z).m_7421_(u, v).m_193479_(color).m_5752_();
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            if (update) {
                RenderProjectileFlashProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.f_85815_) {
                    RenderProjectileFlashProcedure.mode = mode;
                    RenderProjectileFlashProcedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85815_);
                    return true;
                }
                if (format == DefaultVertexFormat.f_85819_) {
                    RenderProjectileFlashProcedure.mode = mode;
                    RenderProjectileFlashProcedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85819_);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vertexBuffer.m_85921_();
        vertexBuffer.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderProjectileFlashProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderProjectileFlashProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            i = (float)(x - pos.m_7096_());
            j = (float)(y - pos.m_7098_());
            k = (float)(z - pos.m_7094_());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(i, j, k);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(xScale, yScale, zScale);
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.m_85921_();
        vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, vertexBuffer.m_166892_().hasUV(0) ? GameRenderer.m_172820_() : GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            RenderSystem.depthMask((boolean)false);
            RenderProjectileFlashProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            RenderSystem.depthMask((boolean)true);
            RenderProjectileFlashProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (level != null && entity != null) {
            poseStack = event.getPoseStack();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.m_20318_(event.getPartialTick());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderProjectileFlashProcedure.execute((Event)event, (LevelAccessor)level);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world) {
        RenderProjectileFlashProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        double scale = 0.0;
        double yvector = 0.0;
        double vmagnitude = 0.0;
        double xvector = 0.0;
        double zvector = 0.0;
        double targetz = 0.0;
        double targetx = 0.0;
        double Yaw = 0.0;
        double pitch = 0.0;
        if (world instanceof ClientLevel) {
            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                Yaw = Math.atan2(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_7096_() - entityiterator.m_20185_(), Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_7094_() - entityiterator.m_20189_()) * 57.29577951308232 * -1.0 + 180.0;
                pitch = Math.atan2(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_7098_() - entityiterator.m_20186_(), Math.sqrt(Math.pow(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_7096_() - entityiterator.m_20185_(), 2.0) + Math.pow(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_7094_() - entityiterator.m_20189_(), 2.0))) * 57.29577951308232 * 1.0 - 90.0;
                if (entityiterator instanceof MuzzleFlashProducerEntity) {
                    if (entityiterator.getPersistentData().m_128459_("Type") == 0.0) {
                        entityiterator.getPersistentData().m_128347_("Type", (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)4));
                    }
                    scale = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)3.95, (double)4.05);
                    if (RenderProjectileFlashProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                        RenderProjectileFlashProcedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.end();
                    }
                    if (RenderProjectileFlashProcedure.target(2)) {
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        if (entityiterator.getPersistentData().m_128459_("Type") == 1.0) {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash.png"));
                        } else if (entityiterator.getPersistentData().m_128459_("Type") == 2.0) {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash2.png"));
                        } else if (entityiterator.getPersistentData().m_128459_("Type") == 3.0) {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash3.png"));
                        } else {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash4.png"));
                        }
                        RenderProjectileFlashProcedure.renderShape(RenderProjectileFlashProcedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_(), entityiterator.m_20189_(), (float)Yaw, (float)pitch, 0.0f, (float)scale, (float)scale, (float)scale, 0xFFFF0000 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255) << 8 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255));
                        RenderProjectileFlashProcedure.release();
                    }
                    RenderProjectileFlashProcedure.clear();
                    continue;
                }
                if (entityiterator instanceof SmallMuzzleFlashProducerEntity) {
                    if (entityiterator.getPersistentData().m_128459_("Type") == 0.0) {
                        entityiterator.getPersistentData().m_128347_("Type", (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)4));
                    }
                    scale = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)2.4, (double)2.6);
                    if (RenderProjectileFlashProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                        RenderProjectileFlashProcedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.end();
                    }
                    if (RenderProjectileFlashProcedure.target(2)) {
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        if (entityiterator.getPersistentData().m_128459_("Type") == 1.0) {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash.png"));
                        } else if (entityiterator.getPersistentData().m_128459_("Type") == 2.0) {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash2.png"));
                        } else if (entityiterator.getPersistentData().m_128459_("Type") == 3.0) {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash3.png"));
                        } else {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/muzzleflash4.png"));
                        }
                        RenderProjectileFlashProcedure.renderShape(RenderProjectileFlashProcedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_(), entityiterator.m_20189_(), (float)Yaw, (float)pitch, 0.0f, (float)scale, (float)scale, (float)scale, 0xFFFF0000 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)230, (int)245) << 8 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)230, (int)245));
                        RenderProjectileFlashProcedure.release();
                    }
                    RenderProjectileFlashProcedure.clear();
                    continue;
                }
                if (entityiterator.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("crusty_chunks:smallflash")))) {
                    scale = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)15.0, (double)17.0);
                    if (RenderProjectileFlashProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                        RenderProjectileFlashProcedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.end();
                    }
                    if (!RenderProjectileFlashProcedure.target(2)) continue;
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/smallflash.png"));
                    RenderProjectileFlashProcedure.renderShape(RenderProjectileFlashProcedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_(), entityiterator.m_20189_(), (float)Yaw, (float)pitch, 0.0f, (float)scale, (float)scale, (float)scale, 0xFFFF0000 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255) << 8 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255));
                    RenderProjectileFlashProcedure.release();
                    continue;
                }
                if (entityiterator.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("crusty_chunks:smallrocketglare"))) && entityiterator.getPersistentData().m_128459_("Time") < entityiterator.getPersistentData().m_128459_("MaxTime")) {
                    scale = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)6.0, (double)7.0);
                    if (RenderProjectileFlashProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                        RenderProjectileFlashProcedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.end();
                    }
                    if (!RenderProjectileFlashProcedure.target(2)) continue;
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/smallflash.png"));
                    RenderProjectileFlashProcedure.renderShape(RenderProjectileFlashProcedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_(), entityiterator.m_20189_(), (float)Yaw, (float)pitch, 0.0f, (float)scale, (float)scale, (float)scale, 0xFFFF0000 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255) << 8 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255));
                    RenderProjectileFlashProcedure.release();
                    continue;
                }
                if (entityiterator.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("crusty_chunks:largerocketglare"))) && entityiterator.getPersistentData().m_128459_("Time") < entityiterator.getPersistentData().m_128459_("MaxTime")) {
                    scale = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)10.0, (double)11.0);
                    if (RenderProjectileFlashProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                        RenderProjectileFlashProcedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                        RenderProjectileFlashProcedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                        RenderProjectileFlashProcedure.end();
                    }
                    if (!RenderProjectileFlashProcedure.target(2)) continue;
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/smallflash.png"));
                    RenderProjectileFlashProcedure.renderShape(RenderProjectileFlashProcedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_(), entityiterator.m_20189_(), (float)Yaw, (float)pitch, 0.0f, (float)scale, (float)scale, (float)scale, 0xFFFF0000 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255) << 8 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255));
                    RenderProjectileFlashProcedure.release();
                    continue;
                }
                if (!entityiterator.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("crusty_chunks:flare")))) continue;
                scale = Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)7.0, (double)8.0);
                if (RenderProjectileFlashProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false)) {
                    RenderProjectileFlashProcedure.add(0.5, 0.0, 0.5, 0.0f, 0.0f, -1);
                    RenderProjectileFlashProcedure.add(0.5, 0.0, -0.5, 0.0f, 1.0f, -1);
                    RenderProjectileFlashProcedure.add(-0.5, 0.0, -0.5, 1.0f, 1.0f, -1);
                    RenderProjectileFlashProcedure.add(-0.5, 0.0, 0.5, 1.0f, 0.0f, -1);
                    RenderProjectileFlashProcedure.end();
                }
                if (!RenderProjectileFlashProcedure.target(2)) continue;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("crusty_chunks:textures/flareglare.png"));
                RenderProjectileFlashProcedure.renderShape(RenderProjectileFlashProcedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_(), entityiterator.m_20189_(), (float)Yaw, (float)pitch, 0.0f, (float)scale, (float)scale, (float)scale, 0xFFFF0000 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255) << 8 | Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)245, (int)255));
                RenderProjectileFlashProcedure.release();
            }
        }
    }
}

