/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Block.Scanner;

import com.Maxwell.cyber_ware_port.Common.Container.ScannerMenu;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Common.Item.BlueprintItem;
import com.Maxwell.cyber_ware_port.Init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScannerBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int SLOT_PAPER = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int MAX_PROGRESS = 2400;
    private static final int SLOT_COUNT = 3;
    protected final ContainerData data;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            ScannerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_150930_(Items.f_42516_);
                case 1 -> stack.m_41720_() instanceof ICyberware;
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final IItemHandler paperInputHandler = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 1){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    private final IItemHandler componentInputHandler = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 1, 2){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    private final IItemHandler outputHandler = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 2, 3){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    private final IItemHandler genericInputHandler = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 2){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    private LazyOptional<IItemHandler> lazyPaperHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyComponentHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyOutputHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyGenericInputHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private int progress = 0;
    private boolean isWorking = false;

    public ScannerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SCANNER.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> ScannerBlockEntity.this.progress;
                    case 1 -> 2400;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                if (pIndex == 0) {
                    ScannerBlockEntity.this.progress = pValue;
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ScannerBlockEntity pEntity) {
        if (pLevel.m_5776_()) {
            if (pEntity.isWorking) {
                ++pEntity.progress;
                if (pEntity.progress >= 2400) {
                    pEntity.progress = 0;
                }
            } else {
                pEntity.progress = 0;
            }
            return;
        }
        if (pEntity.hasRecipe()) {
            ++pEntity.progress;
            if (!pEntity.isWorking) {
                pEntity.isWorking = true;
                pEntity.syncToClient();
            }
            ScannerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pEntity.progress >= 2400) {
                pEntity.craftItem();
                pEntity.progress = 0;
                if (!pEntity.hasRecipe()) {
                    pEntity.isWorking = false;
                    pEntity.syncToClient();
                }
            }
        } else {
            pEntity.resetProgress();
            if (pEntity.isWorking) {
                pEntity.isWorking = false;
                pEntity.syncToClient();
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyPaperHandler = LazyOptional.of(() -> this.paperInputHandler);
        this.lazyComponentHandler = LazyOptional.of(() -> this.componentInputHandler);
        this.lazyOutputHandler = LazyOptional.of(() -> this.outputHandler);
        this.lazyGenericInputHandler = LazyOptional.of(() -> this.genericInputHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyPaperHandler.invalidate();
        this.lazyComponentHandler.invalidate();
        this.lazyOutputHandler.invalidate();
        this.lazyGenericInputHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction right = facing.m_122428_();
            Direction left = facing.m_122427_();
            Direction back = facing.m_122424_();
            if (side == right) {
                return this.lazyOutputHandler.cast();
            }
            if (side == left) {
                return this.lazyComponentHandler.cast();
            }
            if (side == back) {
                return this.lazyPaperHandler.cast();
            }
            return this.lazyGenericInputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private void syncToClient() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public float getProgress() {
        return this.progress;
    }

    private boolean hasRecipe() {
        boolean hasInput;
        ItemStack paperStack = this.itemHandler.getStackInSlot(0);
        ItemStack inputStack = this.itemHandler.getStackInSlot(1);
        ItemStack outputStack = this.itemHandler.getStackInSlot(2);
        boolean bl = hasInput = paperStack.m_150930_(Items.f_42516_) && inputStack.m_41720_() instanceof ICyberware;
        if (!hasInput) {
            return false;
        }
        return outputStack.m_41619_();
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        if (!this.hasRecipe()) {
            return;
        }
        ItemStack inputStack = this.itemHandler.getStackInSlot(1);
        if (this.f_58857_.f_46441_.m_188501_() < 0.5f) {
            ItemStack blueprint = BlueprintItem.createBlueprintFor(inputStack.m_41720_());
            this.itemHandler.setStackInSlot(2, blueprint);
        }
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.extractItem(1, 1, false);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.cyber_ware_port.scanner");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ScannerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("scanner.progress", this.progress);
        pTag.m_128379_("scanner.isWorking", this.isWorking);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("scanner.progress");
        this.isWorking = pTag.m_128471_("scanner.isWorking");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }
}

