/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Block.SurgeryChamber;

import com.Maxwell.cyber_ware_port.Common.Block.SurgeryChamber.SurgeryChamberBlockEntity;
import com.Maxwell.cyber_ware_port.Init.ModBlockEntities;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SurgeryChamberBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final Map<Direction, VoxelShape> LOWER_SHAPES_OPEN = new EnumMap<Direction, VoxelShape>(Direction.class);
    private static final Map<Direction, VoxelShape> UPPER_SHAPES_OPEN = new EnumMap<Direction, VoxelShape>(Direction.class);
    private static final Map<Direction, VoxelShape> LOWER_SHAPES_CLOSED = new EnumMap<Direction, VoxelShape>(Direction.class);
    private static final Map<Direction, VoxelShape> UPPER_SHAPES_CLOSED = new EnumMap<Direction, VoxelShape>(Direction.class);

    public SurgeryChamberBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
    }

    protected static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction toDir) {
        if (toDir == Direction.NORTH) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = 0;
        if (toDir == Direction.EAST) {
            times = 1;
        } else if (toDir == Direction.SOUTH) {
            times = 2;
        } else if (toDir == Direction.WEST) {
            times = 3;
        }
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double newMinX = 1.0 - maxZ;
                double newMaxX = 1.0 - minZ;
                double newMinZ = minX;
                double newMaxZ = maxX;
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)newMinX, (double)minY, (double)newMinZ, (double)newMaxX, (double)maxY, (double)newMaxZ));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, HALF, OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return new SurgeryChamberBlockEntity(pPos, pState);
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockPos targetPos;
        BlockEntity blockEntity;
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (pHand == InteractionHand.MAIN_HAND && (blockEntity = pLevel.m_7702_(targetPos = pState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pPos.m_7495_() : pPos)) instanceof SurgeryChamberBlockEntity) {
            SurgeryChamberBlockEntity chamberEntity = (SurgeryChamberBlockEntity)blockEntity;
            chamberEntity.toggleDoor();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(pContext)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pBlockEntityType == ModBlockEntities.SURGERY_CHAMBER.get()) {
            return (lvl, pos, st, be) -> SurgeryChamberBlockEntity.tick(lvl, pos, st, (SurgeryChamberBlockEntity)be);
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            SurgeryChamberBlock.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (pFacing == Direction.UP) && !pFacingState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (half == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        DoubleBlockHalf half = (DoubleBlockHalf)pState.m_61143_(HALF);
        boolean isOpen = (Boolean)pState.m_61143_((Property)OPEN);
        if (isOpen) {
            return half == DoubleBlockHalf.LOWER ? LOWER_SHAPES_OPEN.getOrDefault(facing, Shapes.m_83144_()) : UPPER_SHAPES_OPEN.getOrDefault(facing, Shapes.m_83144_());
        }
        return half == DoubleBlockHalf.LOWER ? LOWER_SHAPES_CLOSED.getOrDefault(facing, Shapes.m_83144_()) : UPPER_SHAPES_CLOSED.getOrDefault(facing, Shapes.m_83144_());
    }

    static {
        VoxelShape floor = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape ceiling = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape backWall = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape rightWall = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
        VoxelShape leftWall = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0);
        VoxelShape frontWall = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape baseLowerOpen = Shapes.m_83124_((VoxelShape)floor, (VoxelShape[])new VoxelShape[]{backWall, rightWall, leftWall});
        VoxelShape baseUpperOpen = Shapes.m_83124_((VoxelShape)ceiling, (VoxelShape[])new VoxelShape[]{backWall, rightWall, leftWall});
        VoxelShape baseLowerClosed = Shapes.m_83110_((VoxelShape)baseLowerOpen, (VoxelShape)frontWall);
        VoxelShape baseUpperClosed = Shapes.m_83110_((VoxelShape)baseUpperOpen, (VoxelShape)frontWall);
        for (Direction direction : Direction.values()) {
            if (!direction.m_122434_().m_122479_()) continue;
            LOWER_SHAPES_OPEN.put(direction, SurgeryChamberBlock.rotateShape(baseLowerOpen, direction));
            UPPER_SHAPES_OPEN.put(direction, SurgeryChamberBlock.rotateShape(baseUpperOpen, direction));
            LOWER_SHAPES_CLOSED.put(direction, SurgeryChamberBlock.rotateShape(baseLowerClosed, direction));
            UPPER_SHAPES_CLOSED.put(direction, SurgeryChamberBlock.rotateShape(baseUpperClosed, direction));
        }
    }
}

