/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Entity.Monster.CyberSkeleton;

import com.Maxwell.cyber_ware_port.Common.Block.Radio.TemptToBlockGoal;
import com.Maxwell.cyber_ware_port.Common.Entity.ICyberwareMob;
import com.Maxwell.cyber_ware_port.Init.ModBlocks;
import com.Maxwell.cyber_ware_port.Init.ModItems;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class CyberSkeletonEntity
extends Skeleton
implements ICyberwareMob {
    private static final int MELEE_TRIGGER_DIST_SQR = 25;
    private static final int MELEE_EXIT_DIST_SQR = 144;
    private static final int MAX_MELEE_ATTACKS = 9;
    private static final int MELEE_COOLDOWN_TICKS = 100;
    private int meleeCooldown = 0;
    private int attackCounter = 0;
    private boolean isMeleeMode = false;
    private boolean isBackstepping = false;
    private RangedBowAttackGoal<CyberSkeletonEntity> bowGoal;
    private CyberMeleeGoal meleeGoal;
    private CyberBackstepGoal backstepGoal;

    public CyberSkeletonEntity(EntityType<? extends Skeleton> type, Level level) {
        super(type, level);
    }

    @Override
    public List<Item> getSpecialDrops() {
        return Arrays.asList((Item)ModItems.RAPID_FIRE_FLYWHEEL.get(), (Item)ModItems.LINEAR_ACTUATORS.get());
    }

    @Override
    public List<Item> getForbiddenDrops() {
        return Arrays.asList((Item)ModItems.CYBER_ARM_LEFT.get(), (Item)ModItems.CYBER_ARM_RIGHT.get(), (Item)ModItems.CYBER_LEG_LEFT.get(), (Item)ModItems.CYBER_LEG_RIGHT.get(), (Item)ModItems.INTERNAL_DEFIBRILLATOR.get());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 10, 15.0f);
        this.meleeGoal = new CyberMeleeGoal(this, 1.2, false);
        this.backstepGoal = new CyberBackstepGoal(this, 1.0);
        this.f_21345_.m_25352_(3, (Goal)new TemptToBlockGoal((PathfinderMob)this, 1.0, (Block)ModBlocks.RADIO_KIT_BLOCK.get(), 64));
        this.f_21345_.m_25352_(4, (Goal)this.backstepGoal);
        this.f_21345_.m_25352_(5, (Goal)this.meleeGoal);
        this.f_21345_.m_25352_(6, this.bowGoal);
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected boolean m_21527_() {
        return false;
    }

    public void m_32164_() {
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.meleeCooldown > 0) {
            --this.meleeCooldown;
        }
        if ((target = this.m_5448_()) == null || this.isBackstepping) {
            return;
        }
        double distSqr = this.m_20280_((Entity)target);
        if (!this.isMeleeMode && this.meleeCooldown == 0 && distSqr <= 25.0) {
            this.startMeleeMode();
        }
        if (this.isMeleeMode && (distSqr > 144.0 || this.attackCounter >= 9 || !this.m_142582_((Entity)target))) {
            this.endMeleeMode();
        }
    }

    private void startMeleeMode() {
        this.isMeleeMode = true;
        this.attackCounter = 0;
        this.m_21561_(true);
    }

    public void endMeleeMode() {
        this.isMeleeMode = false;
        this.meleeCooldown = 100;
        this.isBackstepping = true;
        this.m_21561_(true);
    }

    public void incrementAttackCounter() {
        ++this.attackCounter;
    }

    public boolean isMeleeMode() {
        return this.isMeleeMode;
    }

    public boolean isBackstepping() {
        return this.isBackstepping;
    }

    public void setBackstepping(boolean backstepping) {
        this.isBackstepping = backstepping;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack arrowStack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.m_6686_(d0, d1 + d3 * 0.2, d2, 2.5f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    class CyberMeleeGoal
    extends MeleeAttackGoal {
        public CyberMeleeGoal(CyberSkeletonEntity mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            return super.m_8036_() && ((CyberSkeletonEntity)this.f_25540_).isMeleeMode();
        }

        public boolean m_8045_() {
            return super.m_8045_() && ((CyberSkeletonEntity)this.f_25540_).isMeleeMode();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.OFF_HAND);
                this.f_25540_.m_7327_((Entity)pEnemy);
                ((CyberSkeletonEntity)this.f_25540_).incrementAttackCounter();
            }
        }
    }

    class CyberBackstepGoal
    extends Goal {
        private final CyberSkeletonEntity mob;
        private final double speedModifier;
        private int timer;
        private double targetX;
        private double targetY;
        private double targetZ;

        public CyberBackstepGoal(CyberSkeletonEntity mob, double speedModifier) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.mob.isBackstepping() && this.mob.m_5448_() != null;
        }

        public void m_8056_() {
            this.timer = 40;
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                Vec3 direction = this.mob.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                Vec3 targetPos = this.mob.m_20182_().m_82549_(direction.m_82490_(5.0));
                this.targetX = targetPos.f_82479_;
                this.targetY = targetPos.f_82480_;
                this.targetZ = targetPos.f_82481_;
                this.mob.m_21573_().m_26519_(this.targetX, this.targetY, this.targetZ, this.speedModifier * 1.5);
            }
        }

        public boolean m_8045_() {
            return this.timer > 0 && this.mob.isBackstepping();
        }

        public void m_8037_() {
            --this.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }

        public void m_8041_() {
            this.mob.setBackstepping(false);
            this.mob.m_21573_().m_26573_();
        }
    }
}

