/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Risk;

import com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon.RobosurgeonBlockEntity;
import com.Maxwell.cyber_ware_port.Common.Item.Base.BodyPartType;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Common.Risk.SurgeryAlert;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SurgeryAnalyzer {
    public static SurgeryAlert check(List<Slot> slots, int maxTolerance) {
        Object type;
        EnumSet<BodyPartType> futureParts = EnumSet.noneOf(BodyPartType.class);
        ArrayList<ItemStack> futureItems = new ArrayList<ItemStack>();
        int projectedCost = 0;
        for (int i = 0; i < RobosurgeonBlockEntity.TOTAL_SLOTS && i < slots.size(); ++i) {
            Item item;
            ItemStack stack = slots.get(i).m_7993_();
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware)) continue;
            ICyberware cyberware = (ICyberware)item;
            projectedCost += cyberware.getEssenceCost(stack) * stack.m_41613_();
            type = cyberware.getBodyPartType(stack);
            if (type != BodyPartType.NONE) {
                futureParts.add((BodyPartType)((Object)type));
            }
            futureItems.add(stack);
        }
        for (ItemStack stack : futureItems) {
            type = stack.m_41720_();
            if (!(type instanceof ICyberware)) continue;
            ICyberware cw = (ICyberware)type;
            for (Item req : cw.getPrerequisites(stack)) {
                boolean found = false;
                for (ItemStack other : futureItems) {
                    if (other.m_41720_() != req) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return SurgeryAlert.create("cyberware.risk.missing_requirement", ChatFormatting.RED);
            }
        }
        int remainingTolerance = maxTolerance - projectedCost;
        boolean hasRightLeg = SurgeryAnalyzer.hasItemInSlot(slots, RobosurgeonBlockEntity.SLOT_LEGS);
        boolean hasLeftLeg = SurgeryAnalyzer.hasItemInSlot(slots, RobosurgeonBlockEntity.SLOT_LEGS + 1);
        boolean hasRightArm = SurgeryAnalyzer.hasItemInSlot(slots, RobosurgeonBlockEntity.SLOT_ARMS);
        boolean hasLeftArm = SurgeryAnalyzer.hasItemInSlot(slots, RobosurgeonBlockEntity.SLOT_ARMS + 1);
        if (!futureParts.contains((Object)BodyPartType.BRAIN)) {
            return SurgeryAlert.create("cyberware.risk.missing_brain", ChatFormatting.RED);
        }
        if (!futureParts.contains((Object)BodyPartType.HEART)) {
            return SurgeryAlert.create("cyberware.risk.missing_heart", ChatFormatting.RED);
        }
        if (!futureParts.contains((Object)BodyPartType.MUSCLE)) {
            return SurgeryAlert.create("cyberware.risk.missing_muscle_death", ChatFormatting.RED);
        }
        if (remainingTolerance <= 0) {
            return SurgeryAlert.create("cyberware.risk.zero_tolerance", ChatFormatting.RED);
        }
        if (!futureParts.contains((Object)BodyPartType.LUNGS)) {
            return SurgeryAlert.create("cyberware.risk.missing_lungs", ChatFormatting.GOLD);
        }
        if (!hasRightLeg && !hasLeftLeg) {
            return SurgeryAlert.create("cyberware.risk.missing_legs_both", ChatFormatting.GOLD);
        }
        if (!futureParts.contains((Object)BodyPartType.SKIN)) {
            return SurgeryAlert.create("cyberware.risk.missing_skin", ChatFormatting.YELLOW);
        }
        if (!futureParts.contains((Object)BodyPartType.BONES)) {
            return SurgeryAlert.create("cyberware.risk.missing_bones", ChatFormatting.YELLOW);
        }
        if (!futureParts.contains((Object)BodyPartType.EYES)) {
            return SurgeryAlert.create("cyberware.risk.missing_eyes", ChatFormatting.YELLOW);
        }
        if (!hasRightArm) {
            return SurgeryAlert.create("cyberware.risk.missing_arm_right", ChatFormatting.YELLOW);
        }
        if (!hasLeftArm) {
            return SurgeryAlert.create("cyberware.risk.missing_arm_left", ChatFormatting.YELLOW);
        }
        if (!hasRightLeg || !hasLeftLeg) {
            return SurgeryAlert.create("cyberware.risk.missing_leg_single", ChatFormatting.YELLOW);
        }
        if (!futureParts.contains((Object)BodyPartType.STOMACH)) {
            return SurgeryAlert.create("cyberware.risk.missing_stomach", ChatFormatting.YELLOW);
        }
        int dangerThreshold = (int)((float)maxTolerance * 0.25f);
        if (remainingTolerance < dangerThreshold) {
            return SurgeryAlert.create("cyberware.risk.low_tolerance", ChatFormatting.YELLOW);
        }
        return null;
    }

    private static boolean hasItemInSlot(List<Slot> slots, int index) {
        if (index >= slots.size()) {
            return false;
        }
        ItemStack stack = slots.get(index).m_7993_();
        return !stack.m_41619_() && stack.m_41720_() instanceof ICyberware;
    }
}

