/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks.entities;

import com.tomboshoven.minecraft.magicdoorknob.items.Items;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.ModelTextureProperty;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.TextureSourceReference;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.model.data.ModelProperty;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public abstract class MagicDoorwayPartBaseBlockEntity
extends BlockEntity {
    public static final ModelTextureProperty TEXTURE_MAIN = ModelTextureProperty.get(ResourceLocation.fromNamespaceAndPath((String)"property", (String)"texture_main"));
    public static final ModelTextureProperty TEXTURE_HIGHLIGHT = ModelTextureProperty.get(ResourceLocation.fromNamespaceAndPath((String)"property", (String)"texture_highlight"));
    public static final ModelTextureProperty TEXTURE_PARTICLE = ModelTextureProperty.get(ResourceLocation.fromNamespaceAndPath((String)"property", (String)"texture_particle"));
    private BlockState baseBlockState = Blocks.AIR.defaultBlockState();
    @Nullable
    private MagicDoorknobItem doorknob;

    MagicDoorwayPartBaseBlockEntity(BlockEntityType<? extends MagicDoorwayPartBaseBlockEntity> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.saveInternal(output);
    }

    private void saveInternal(ValueOutput output) {
        output.store("baseBlock", BlockState.CODEC, (Object)this.baseBlockState);
        if (this.doorknob != null) {
            output.putString("doorknobType", this.doorknob.getTypeName());
        }
    }

    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.loadInternal(valueInput);
    }

    private void loadInternal(ValueInput valueInput) {
        this.baseBlockState = valueInput.read("baseBlock", BlockState.CODEC).orElse(Blocks.AIR.defaultBlockState());
        valueInput.getString("doorknobType").ifPresent(doorknobType -> {
            DeferredItem<MagicDoorknobItem> deferredDoorknob = Items.DOORKNOBS.get(doorknobType);
            this.doorknob = deferredDoorknob != null ? (MagicDoorknobItem)((Object)((Object)deferredDoorknob.get())) : null;
        });
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)lookupProvider);
        this.saveInternal((ValueOutput)valueOutput);
        return valueOutput.buildResult();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ValueInput valueInput) {
        this.loadInternal(valueInput);
        this.requestModelDataUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        Level level = this.getLevel();
        BlockPos blockPos = this.getBlockPos();
        Material emptyMaterial = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)"magic_doorknob", (String)"block/empty"));
        TextureSourceReference.MaterialTextureSource fallbackReference = new TextureSourceReference.MaterialTextureSource(emptyMaterial);
        TextureSourceReference.BlockParticle particleTextureSourceReference = new TextureSourceReference.BlockParticle(level, blockPos, this.baseBlockState, fallbackReference);
        TextureSourceReference.BlockLookup blockTextureSourceReference = new TextureSourceReference.BlockLookup(level, blockPos, this.baseBlockState, fallbackReference);
        Record doorknobTextureSourceReference = this.doorknob == null ? blockTextureSourceReference : new TextureSourceReference.MaterialTextureSource(this.doorknob.getMainMaterial());
        return ModelData.builder().with((ModelProperty)TEXTURE_MAIN, (Object)blockTextureSourceReference).with((ModelProperty)TEXTURE_HIGHLIGHT, (Object)doorknobTextureSourceReference).with((ModelProperty)TEXTURE_PARTICLE, (Object)particleTextureSourceReference).build();
    }

    public BlockState getBaseBlockState() {
        return this.baseBlockState;
    }

    public void setBaseBlockState(BlockState baseBlockState) {
        this.baseBlockState = baseBlockState;
    }

    @Nullable
    public MagicDoorknobItem getDoorknob() {
        return this.doorknob;
    }

    public void setDoorknob(MagicDoorknobItem doorknob) {
        this.doorknob = doorknob;
    }
}

