/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured;

import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.PropertySprite;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.TextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.ModelTextureProperty;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.TextureSourceReference;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.model.data.ModelProperty;

class ModelDataTextureMapper
implements TextureMapper {
    ModelDataTextureMapper() {
    }

    @Override
    public TextureMapper.BlockStateTextureMapper forBlockState(@Nullable BlockState blockState, @Nullable ModelData modelData) {
        if (modelData == null) {
            return new TextureMapper.BlockStateTextureMapper.Empty();
        }
        final Map<ModelTextureProperty, TextureSourceReference> lookup = ModelDataTextureMapper.distill(modelData);
        return new TextureMapper.BlockStateTextureMapper(){

            @Override
            public Object getMappingKey() {
                return lookup;
            }

            @Override
            @Nullable
            public TextureSourceReference mapSprite(PropertySprite spriteToMap) {
                ResourceLocation name = spriteToMap.contents().name();
                ModelTextureProperty modelProperty = ModelTextureProperty.get(name);
                return (TextureSourceReference)lookup.get((Object)modelProperty);
            }
        };
    }

    private static Map<ModelTextureProperty, TextureSourceReference> distill(ModelData modelData) {
        Reference2ObjectArrayMap result = new Reference2ObjectArrayMap();
        for (ModelProperty property : modelData.getProperties()) {
            ModelTextureProperty modelTextureProperty;
            TextureSourceReference value;
            if (!(property instanceof ModelTextureProperty) || (value = (TextureSourceReference)modelData.get((ModelProperty)(modelTextureProperty = (ModelTextureProperty)property))) == null) continue;
            result.put(modelTextureProperty, value);
        }
        if (result.size() > 4) {
            return new Reference2ObjectOpenHashMap((Map)result);
        }
        return result;
    }
}

